-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Active Strength skill gems
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["AbyssalCry"] = {
	name = "Abyssal Cry",
	color = 1,
	description = "Performs a warcry, Hindering nearby enemies and causing them to explode when killed. The hinder effect is increased by surrounding enemies. Taunts all nearby enemies to attack the user. Shares a cooldown with other Warcry skills.",
	skillTypes = { [11] = true, [12] = true, [50] = true, [10] = true, },
	castTime = 0.25,
	statMap = {
		["base_movement_velocity_+%"] = {
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
		chaos = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "skill_effect_duration_+%", 1 },
	},
	stats = {
		"abyssal_cry_movement_velocity_+%_per_one_hundred_nearby_enemies",
		"base_movement_velocity_+%",
		"abyssal_cry_%_max_life_as_chaos_on_death",
		"base_skill_effect_duration",
		"damage_cannot_be_reflected",
		"base_skill_show_average_damage_instead_of_dps",
		"display_skill_deals_secondary_damage",
		"is_warcry",
	},
	levels = {
		[1] = { -60, -20, 8, 6000, cooldown = 4, levelRequirement = 34, manaCost = 26, statInterpolation = { }, },
		[2] = { -62, -20, 8, 6000, cooldown = 4, levelRequirement = 36, manaCost = 28, statInterpolation = { }, },
		[3] = { -62, -21, 8, 6000, cooldown = 4, levelRequirement = 38, manaCost = 30, statInterpolation = { }, },
		[4] = { -64, -21, 8, 6000, cooldown = 4, levelRequirement = 40, manaCost = 32, statInterpolation = { }, },
		[5] = { -66, -21, 8, 6000, cooldown = 4, levelRequirement = 42, manaCost = 34, statInterpolation = { }, },
		[6] = { -66, -22, 8, 6000, cooldown = 4, levelRequirement = 44, manaCost = 36, statInterpolation = { }, },
		[7] = { -68, -22, 8, 6000, cooldown = 4, levelRequirement = 46, manaCost = 38, statInterpolation = { }, },
		[8] = { -70, -22, 8, 6000, cooldown = 4, levelRequirement = 48, manaCost = 40, statInterpolation = { }, },
		[9] = { -70, -23, 8, 6000, cooldown = 4, levelRequirement = 50, manaCost = 43, statInterpolation = { }, },
		[10] = { -72, -23, 8, 6000, cooldown = 4, levelRequirement = 52, manaCost = 45, statInterpolation = { }, },
		[11] = { -74, -23, 8, 6000, cooldown = 4, levelRequirement = 54, manaCost = 48, statInterpolation = { }, },
		[12] = { -74, -24, 8, 6000, cooldown = 4, levelRequirement = 56, manaCost = 49, statInterpolation = { }, },
		[13] = { -76, -24, 8, 6000, cooldown = 4, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[14] = { -78, -24, 8, 6000, cooldown = 4, levelRequirement = 60, manaCost = 51, statInterpolation = { }, },
		[15] = { -78, -25, 8, 6000, cooldown = 4, levelRequirement = 62, manaCost = 52, statInterpolation = { }, },
		[16] = { -80, -25, 8, 6000, cooldown = 4, levelRequirement = 64, manaCost = 53, statInterpolation = { }, },
		[17] = { -82, -25, 8, 6000, cooldown = 4, levelRequirement = 66, manaCost = 54, statInterpolation = { }, },
		[18] = { -82, -26, 8, 6000, cooldown = 4, levelRequirement = 68, manaCost = 54, statInterpolation = { }, },
		[19] = { -84, -26, 8, 6000, cooldown = 4, levelRequirement = 69, manaCost = 55, statInterpolation = { }, },
		[20] = { -86, -26, 8, 6000, cooldown = 4, levelRequirement = 70, manaCost = 56, statInterpolation = { }, },
		[21] = { -86, -27, 8, 6000, cooldown = 4, levelRequirement = 72, manaCost = 57, statInterpolation = { }, },
		[22] = { -88, -27, 8, 6000, cooldown = 4, levelRequirement = 74, manaCost = 58, statInterpolation = { }, },
		[23] = { -90, -27, 8, 6000, cooldown = 4, levelRequirement = 76, manaCost = 58, statInterpolation = { }, },
		[24] = { -90, -28, 8, 6000, cooldown = 4, levelRequirement = 78, manaCost = 59, statInterpolation = { }, },
		[25] = { -92, -28, 8, 6000, cooldown = 4, levelRequirement = 80, manaCost = 60, statInterpolation = { }, },
		[26] = { -94, -28, 8, 6000, cooldown = 4, levelRequirement = 82, manaCost = 61, statInterpolation = { }, },
		[27] = { -94, -29, 8, 6000, cooldown = 4, levelRequirement = 84, manaCost = 62, statInterpolation = { }, },
		[28] = { -96, -29, 8, 6000, cooldown = 4, levelRequirement = 86, manaCost = 62, statInterpolation = { }, },
		[29] = { -98, -29, 8, 6000, cooldown = 4, levelRequirement = 88, manaCost = 63, statInterpolation = { }, },
		[30] = { -98, -30, 8, 6000, cooldown = 4, levelRequirement = 90, manaCost = 64, statInterpolation = { }, },
	},
}
skills["TotemMelee"] = {
	name = "Ancestral Protector",
	color = 1,
	description = "Summons an Ancestor Totem which will attack enemies with melee strikes while you stand close to it. Being near it grants you more attack speed.",
	skillTypes = { [1] = true, [30] = true, [12] = true, [6] = true, [25] = true, [24] = true, [17] = true, [19] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	skillTotemId = 13,
	castTime = 1,
	statMap = {
		["melee_ancestor_totem_grant_owner_attack_speed_+%_final"] = {
			mod("Speed", "MORE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		totem = true,
		duration = true,
		forceMainHand = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		skill("thisIsNotABuff", true),
	},
	qualityStats = {
		{ "totem_damage_+%", 1 },
	},
	stats = {
		"base_totem_duration",
		"base_totem_range",
		"base_active_skill_totem_level",
		"melee_range_+",
		"ancestor_totem_parent_activiation_range",
		"summon_totem_cast_speed_+%",
		"melee_ancestor_totem_grant_owner_attack_speed_+%_final",
		"base_skill_is_totemified",
		"is_totem",
	},
	levels = {
		[1] = { 12000, 50, 4, 16, 70, 50, 10, damageMultiplier = -20, levelRequirement = 4, manaCost = 8, statInterpolation = { }, },
		[2] = { 12000, 50, 6, 16, 70, 50, 11, damageMultiplier = -17.2, levelRequirement = 6, manaCost = 8, statInterpolation = { }, },
		[3] = { 12000, 50, 9, 16, 70, 50, 11, damageMultiplier = -14.4, levelRequirement = 9, manaCost = 8, statInterpolation = { }, },
		[4] = { 12000, 50, 12, 16, 70, 50, 12, damageMultiplier = -11.6, levelRequirement = 12, manaCost = 8, statInterpolation = { }, },
		[5] = { 12000, 50, 16, 16, 70, 50, 12, damageMultiplier = -8.8, levelRequirement = 16, manaCost = 8, statInterpolation = { }, },
		[6] = { 12000, 50, 20, 16, 70, 50, 13, damageMultiplier = -6, levelRequirement = 20, manaCost = 8, statInterpolation = { }, },
		[7] = { 12000, 50, 24, 16, 70, 50, 13, damageMultiplier = -3.2, levelRequirement = 24, manaCost = 8, statInterpolation = { }, },
		[8] = { 12000, 50, 28, 16, 70, 50, 14, damageMultiplier = -0.4, levelRequirement = 28, manaCost = 8, statInterpolation = { }, },
		[9] = { 12000, 50, 32, 16, 70, 50, 14, damageMultiplier = 2.4, levelRequirement = 32, manaCost = 8, statInterpolation = { }, },
		[10] = { 12000, 50, 36, 16, 70, 50, 15, damageMultiplier = 5.2, levelRequirement = 36, manaCost = 8, statInterpolation = { }, },
		[11] = { 12000, 50, 40, 16, 70, 50, 15, damageMultiplier = 8, levelRequirement = 40, manaCost = 8, statInterpolation = { }, },
		[12] = { 12000, 50, 44, 16, 70, 50, 16, damageMultiplier = 10.8, levelRequirement = 44, manaCost = 8, statInterpolation = { }, },
		[13] = { 12000, 50, 48, 16, 70, 50, 16, damageMultiplier = 13.6, levelRequirement = 48, manaCost = 8, statInterpolation = { }, },
		[14] = { 12000, 50, 52, 16, 70, 50, 17, damageMultiplier = 16.4, levelRequirement = 52, manaCost = 8, statInterpolation = { }, },
		[15] = { 12000, 50, 55, 16, 70, 50, 17, damageMultiplier = 19.2, levelRequirement = 55, manaCost = 8, statInterpolation = { }, },
		[16] = { 12000, 50, 58, 16, 70, 50, 18, damageMultiplier = 22, levelRequirement = 58, manaCost = 8, statInterpolation = { }, },
		[17] = { 12000, 50, 61, 16, 70, 50, 18, damageMultiplier = 24.8, levelRequirement = 61, manaCost = 8, statInterpolation = { }, },
		[18] = { 12000, 50, 64, 16, 70, 50, 19, damageMultiplier = 27.6, levelRequirement = 64, manaCost = 8, statInterpolation = { }, },
		[19] = { 12000, 50, 67, 16, 70, 50, 19, damageMultiplier = 30.4, levelRequirement = 67, manaCost = 8, statInterpolation = { }, },
		[20] = { 12000, 50, 70, 16, 70, 50, 20, damageMultiplier = 33.2, levelRequirement = 70, manaCost = 8, statInterpolation = { }, },
		[21] = { 12000, 50, 72, 16, 70, 50, 20, damageMultiplier = 36, levelRequirement = 72, manaCost = 8, statInterpolation = { }, },
		[22] = { 12000, 50, 74, 16, 70, 50, 21, damageMultiplier = 38.8, levelRequirement = 74, manaCost = 8, statInterpolation = { }, },
		[23] = { 12000, 50, 76, 16, 70, 50, 21, damageMultiplier = 41.6, levelRequirement = 76, manaCost = 8, statInterpolation = { }, },
		[24] = { 12000, 50, 78, 16, 70, 50, 22, damageMultiplier = 44.4, levelRequirement = 78, manaCost = 8, statInterpolation = { }, },
		[25] = { 12000, 50, 80, 16, 70, 50, 22, damageMultiplier = 47.2, levelRequirement = 80, manaCost = 8, statInterpolation = { }, },
		[26] = { 12000, 50, 82, 16, 70, 50, 23, damageMultiplier = 50, levelRequirement = 82, manaCost = 8, statInterpolation = { }, },
		[27] = { 12000, 50, 84, 16, 70, 50, 23, damageMultiplier = 52.8, levelRequirement = 84, manaCost = 8, statInterpolation = { }, },
		[28] = { 12000, 50, 86, 16, 70, 50, 24, damageMultiplier = 55.6, levelRequirement = 86, manaCost = 8, statInterpolation = { }, },
		[29] = { 12000, 50, 88, 16, 70, 50, 24, damageMultiplier = 58.4, levelRequirement = 88, manaCost = 8, statInterpolation = { }, },
		[30] = { 12000, 50, 90, 16, 70, 50, 25, damageMultiplier = 61.2, levelRequirement = 90, manaCost = 8, statInterpolation = { }, },
	},
}
skills["AncestorTotemSlam"] = {
	name = "Ancestral Warchief",
	color = 1,
	description = "Summons an Ancestor Totem that will attack enemies with a powerful main hand slam while you stand close to it. Being near it grants you more melee damage.",
	skillTypes = { [1] = true, [30] = true, [12] = true, [6] = true, [24] = true, [17] = true, [19] = true, [11] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	skillTotemId = 15,
	castTime = 1,
	statMap = {
		["slam_ancestor_totem_grant_owner_melee_damage_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Melee, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Ancestral Warchief" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		totem = true,
		area = true,
		duration = true,
		forceMainHand = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		skill("thisIsNotABuff", true),
	},
	qualityStats = {
		{ "totem_damage_+%", 1 },
	},
	stats = {
		"base_totem_duration",
		"base_totem_range",
		"base_active_skill_totem_level",
		"ancestor_totem_parent_activiation_range",
		"summon_totem_cast_speed_+%",
		"slam_ancestor_totem_grant_owner_melee_damage_+%_final",
		"active_skill_attack_speed_+%_final",
		"melee_range_+",
		"is_area_damage",
		"base_skill_is_totemified",
		"is_totem",
	},
	levels = {
		[1] = { 12000, 50, 28, 70, 50, 8, -10, 10, manaCost = 10, levelRequirement = 28, statInterpolation = { }, },
		[2] = { 12000, 50, 31, 70, 50, 8, -10, 10, damageMultiplier = 1.2, levelRequirement = 31, manaCost = 10, statInterpolation = { }, },
		[3] = { 12000, 50, 34, 70, 50, 9, -10, 10, damageMultiplier = 2.4, levelRequirement = 34, manaCost = 10, statInterpolation = { }, },
		[4] = { 12000, 50, 37, 70, 50, 10, -10, 10, damageMultiplier = 3.6, levelRequirement = 37, manaCost = 10, statInterpolation = { }, },
		[5] = { 12000, 50, 40, 70, 50, 10, -10, 10, damageMultiplier = 4.8, levelRequirement = 40, manaCost = 10, statInterpolation = { }, },
		[6] = { 12000, 50, 42, 70, 50, 10, -10, 10, damageMultiplier = 6, levelRequirement = 42, manaCost = 10, statInterpolation = { }, },
		[7] = { 12000, 50, 44, 70, 50, 11, -10, 10, damageMultiplier = 7.2, levelRequirement = 44, manaCost = 10, statInterpolation = { }, },
		[8] = { 12000, 50, 46, 70, 50, 12, -10, 10, damageMultiplier = 8.4, levelRequirement = 46, manaCost = 10, statInterpolation = { }, },
		[9] = { 12000, 50, 48, 70, 50, 12, -10, 10, damageMultiplier = 9.6, levelRequirement = 48, manaCost = 10, statInterpolation = { }, },
		[10] = { 12000, 50, 50, 70, 50, 12, -10, 10, damageMultiplier = 10.8, levelRequirement = 50, manaCost = 10, statInterpolation = { }, },
		[11] = { 12000, 50, 52, 70, 50, 13, -10, 10, damageMultiplier = 12, levelRequirement = 52, manaCost = 10, statInterpolation = { }, },
		[12] = { 12000, 50, 54, 70, 50, 14, -10, 10, damageMultiplier = 13.2, levelRequirement = 54, manaCost = 10, statInterpolation = { }, },
		[13] = { 12000, 50, 56, 70, 50, 14, -10, 10, damageMultiplier = 14.4, levelRequirement = 56, manaCost = 10, statInterpolation = { }, },
		[14] = { 12000, 50, 58, 70, 50, 14, -10, 10, damageMultiplier = 15.6, levelRequirement = 58, manaCost = 10, statInterpolation = { }, },
		[15] = { 12000, 50, 60, 70, 50, 15, -10, 10, damageMultiplier = 16.8, levelRequirement = 60, manaCost = 10, statInterpolation = { }, },
		[16] = { 12000, 50, 62, 70, 50, 16, -10, 10, damageMultiplier = 18, levelRequirement = 62, manaCost = 10, statInterpolation = { }, },
		[17] = { 12000, 50, 64, 70, 50, 16, -10, 10, damageMultiplier = 19.2, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[18] = { 12000, 50, 66, 70, 50, 16, -10, 10, damageMultiplier = 20.4, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 12000, 50, 68, 70, 50, 17, -10, 10, damageMultiplier = 21.6, levelRequirement = 68, manaCost = 10, statInterpolation = { }, },
		[20] = { 12000, 50, 70, 70, 50, 18, -10, 10, damageMultiplier = 22.8, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 12000, 50, 72, 70, 50, 18, -10, 10, damageMultiplier = 24, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { 12000, 50, 74, 70, 50, 18, -10, 10, damageMultiplier = 25.2, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 12000, 50, 76, 70, 50, 19, -10, 10, damageMultiplier = 26.4, levelRequirement = 76, manaCost = 10, statInterpolation = { }, },
		[24] = { 12000, 50, 78, 70, 50, 20, -10, 10, damageMultiplier = 27.6, levelRequirement = 78, manaCost = 10, statInterpolation = { }, },
		[25] = { 12000, 50, 80, 70, 50, 20, -10, 10, damageMultiplier = 28.8, levelRequirement = 80, manaCost = 10, statInterpolation = { }, },
		[26] = { 12000, 50, 82, 70, 50, 20, -10, 10, damageMultiplier = 30, levelRequirement = 82, manaCost = 10, statInterpolation = { }, },
		[27] = { 12000, 50, 84, 70, 50, 21, -10, 10, damageMultiplier = 31.2, levelRequirement = 84, manaCost = 10, statInterpolation = { }, },
		[28] = { 12000, 50, 86, 70, 50, 22, -10, 10, damageMultiplier = 32.4, levelRequirement = 86, manaCost = 10, statInterpolation = { }, },
		[29] = { 12000, 50, 88, 70, 50, 22, -10, 10, damageMultiplier = 33.6, levelRequirement = 88, manaCost = 10, statInterpolation = { }, },
		[30] = { 12000, 50, 90, 70, 50, 22, -10, 10, damageMultiplier = 44.8, levelRequirement = 90, manaCost = 10, statInterpolation = { }, },
	},
}
skills["Anger"] = {
	name = "Anger",
	color = 1,
	description = "Casts an aura that adds fire damage to the attacks and spells of you and your allies.",
	skillTypes = { [2] = true, [11] = true, [5] = true, [15] = true, [27] = true, [16] = true, [18] = true, [44] = true, [33] = true, },
	castTime = 1.2,
	statMap = {
		["attack_minimum_added_fire_damage"] = {
			mod("FireMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_maximum_added_fire_damage"] = {
			mod("FireMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_minimum_added_fire_damage"] = {
			mod("FireMin", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_maximum_added_fire_damage"] = {
			mod("FireMax", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"base_skill_area_of_effect_+%",
		"spell_minimum_added_fire_damage",
		"spell_maximum_added_fire_damage",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 12, 21, 0, 10, 16, cooldown = 1.2, levelRequirement = 24, manaCost = 50, statInterpolation = { }, },
		[2] = { 14, 24, 3, 12, 19, cooldown = 1.2, levelRequirement = 27, manaCost = 50, statInterpolation = { }, },
		[3] = { 17, 28, 6, 14, 22, cooldown = 1.2, levelRequirement = 30, manaCost = 50, statInterpolation = { }, },
		[4] = { 19, 32, 9, 16, 26, cooldown = 1.2, levelRequirement = 33, manaCost = 50, statInterpolation = { }, },
		[5] = { 22, 37, 12, 18, 29, cooldown = 1.2, levelRequirement = 36, manaCost = 50, statInterpolation = { }, },
		[6] = { 25, 42, 15, 21, 33, cooldown = 1.2, levelRequirement = 39, manaCost = 50, statInterpolation = { }, },
		[7] = { 28, 47, 18, 24, 38, cooldown = 1.2, levelRequirement = 42, manaCost = 50, statInterpolation = { }, },
		[8] = { 32, 54, 21, 27, 43, cooldown = 1.2, levelRequirement = 45, manaCost = 50, statInterpolation = { }, },
		[9] = { 36, 61, 23, 30, 48, cooldown = 1.2, levelRequirement = 48, manaCost = 50, statInterpolation = { }, },
		[10] = { 39, 66, 25, 33, 53, cooldown = 1.2, levelRequirement = 50, manaCost = 50, statInterpolation = { }, },
		[11] = { 43, 71, 27, 35, 57, cooldown = 1.2, levelRequirement = 52, manaCost = 50, statInterpolation = { }, },
		[12] = { 46, 77, 29, 38, 61, cooldown = 1.2, levelRequirement = 54, manaCost = 50, statInterpolation = { }, },
		[13] = { 50, 83, 31, 41, 66, cooldown = 1.2, levelRequirement = 56, manaCost = 50, statInterpolation = { }, },
		[14] = { 54, 89, 33, 45, 71, cooldown = 1.2, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[15] = { 58, 96, 35, 48, 77, cooldown = 1.2, levelRequirement = 60, manaCost = 50, statInterpolation = { }, },
		[16] = { 62, 104, 36, 52, 83, cooldown = 1.2, levelRequirement = 62, manaCost = 50, statInterpolation = { }, },
		[17] = { 67, 111, 37, 56, 89, cooldown = 1.2, levelRequirement = 64, manaCost = 50, statInterpolation = { }, },
		[18] = { 72, 120, 38, 60, 96, cooldown = 1.2, levelRequirement = 66, manaCost = 50, statInterpolation = { }, },
		[19] = { 77, 129, 39, 64, 103, cooldown = 1.2, levelRequirement = 68, manaCost = 50, statInterpolation = { }, },
		[20] = { 83, 138, 40, 69, 110, cooldown = 1.2, levelRequirement = 70, manaCost = 50, statInterpolation = { }, },
		[21] = { 89, 148, 41, 74, 118, cooldown = 1.2, levelRequirement = 72, manaCost = 50, statInterpolation = { }, },
		[22] = { 95, 159, 42, 79, 127, cooldown = 1.2, levelRequirement = 74, manaCost = 50, statInterpolation = { }, },
		[23] = { 102, 170, 43, 85, 136, cooldown = 1.2, levelRequirement = 76, manaCost = 50, statInterpolation = { }, },
		[24] = { 109, 182, 44, 91, 146, cooldown = 1.2, levelRequirement = 78, manaCost = 50, statInterpolation = { }, },
		[25] = { 117, 195, 45, 97, 156, cooldown = 1.2, levelRequirement = 80, manaCost = 50, statInterpolation = { }, },
		[26] = { 125, 209, 46, 104, 167, cooldown = 1.2, levelRequirement = 82, manaCost = 50, statInterpolation = { }, },
		[27] = { 134, 223, 47, 112, 178, cooldown = 1.2, levelRequirement = 84, manaCost = 50, statInterpolation = { }, },
		[28] = { 143, 238, 48, 119, 191, cooldown = 1.2, levelRequirement = 86, manaCost = 50, statInterpolation = { }, },
		[29] = { 153, 255, 49, 127, 204, cooldown = 1.2, levelRequirement = 88, manaCost = 50, statInterpolation = { }, },
		[30] = { 163, 272, 50, 136, 218, cooldown = 1.2, levelRequirement = 90, manaCost = 50, statInterpolation = { }, },
	},
}
skills["AnimateArmour"] = {
	name = "Animate Guardian",
	color = 1,
	description = "Animates a melee weapon or armour, attaching it to an invisible Guardian that fights by your side. Animating multiple items attaches them to the same Guardian. You cannot animate unidentified weapons.",
	skillTypes = { [2] = true, [9] = true, [21] = true, [18] = true, [36] = true, [49] = true, },
	minionSkillTypes = { [1] = true, [24] = true, [25] = true, [28] = true, },
	castTime = 0.6,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
		["Weapon 2"] = true,
		["Helmet"] = true,
		["Body Armour"] = true,
		["Gloves"] = true,
		["Boots"] = true,
	},
	minionList = {
		"AnimatedArmour",
	},
	statMap = {
		["maximum_life_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("Life", "INC", nil) }),
		},
		["base_movement_velocity_+%"] =  {
			mod("MinionModifier", "LIST", { mod = mod("MovementSpeed", "INC", nil) }),
		},
		["melee_physical_damage_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalDamage", "INC", nil, ModFlag.Melee) }),
		},
		["attack_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_movement_velocity_+%", 2 },
	},
	stats = {
		"emerge_speed_+%",
		"animate_item_maximum_level_requirement",
		"maximum_life_+%",
		"melee_physical_damage_+%",
		"display_minion_monster_level",
		"display_minion_monster_type",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
	},
	levels = {
		[1] = { 100, 33, 0, 0, 28, 3, 22, 34, manaCost = 19, levelRequirement = 28, statInterpolation = { }, },
		[2] = { 100, 36, 4, 4, 31, 3, 25, 37, manaCost = 20, levelRequirement = 31, statInterpolation = { }, },
		[3] = { 100, 39, 8, 8, 34, 3, 27, 41, manaCost = 21, levelRequirement = 34, statInterpolation = { }, },
		[4] = { 100, 43, 12, 12, 37, 3, 30, 44, manaCost = 23, levelRequirement = 37, statInterpolation = { }, },
		[5] = { 100, 46, 16, 16, 40, 3, 32, 48, manaCost = 24, levelRequirement = 40, statInterpolation = { }, },
		[6] = { 100, 48, 20, 20, 42, 3, 34, 50, manaCost = 25, levelRequirement = 42, statInterpolation = { }, },
		[7] = { 100, 51, 24, 24, 44, 3, 35, 53, manaCost = 25, levelRequirement = 44, statInterpolation = { }, },
		[8] = { 100, 53, 28, 28, 46, 3, 37, 55, manaCost = 26, levelRequirement = 46, statInterpolation = { }, },
		[9] = { 100, 56, 32, 32, 48, 3, 38, 58, manaCost = 27, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 100, 58, 36, 36, 50, 3, 40, 60, manaCost = 28, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 100, 61, 40, 40, 52, 3, 42, 62, manaCost = 29, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 100, 63, 44, 44, 54, 3, 43, 65, manaCost = 30, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 100, 66, 48, 48, 56, 3, 45, 67, manaCost = 31, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 100, 68, 52, 52, 58, 3, 46, 70, manaCost = 31, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 100, 71, 56, 56, 60, 3, 48, 72, manaCost = 32, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 100, 73, 60, 60, 62, 3, 50, 74, manaCost = 33, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 100, 76, 64, 64, 64, 3, 51, 77, manaCost = 34, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 100, 79, 68, 68, 66, 3, 53, 79, manaCost = 35, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 100, 82, 72, 72, 68, 3, 54, 82, manaCost = 36, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 100, 100, 76, 76, 70, 3, 56, 84, manaCost = 36, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 100, 100, 80, 80, 72, 3, 58, 86, manaCost = 37, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 100, 100, 84, 84, 74, 3, 59, 89, manaCost = 38, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 100, 100, 88, 88, 76, 3, 61, 91, manaCost = 39, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 100, 100, 92, 92, 78, 3, 62, 94, manaCost = 40, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 100, 100, 96, 96, 80, 3, 64, 96, manaCost = 41, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 100, 100, 100, 100, 82, 3, 66, 98, manaCost = 41, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 100, 100, 104, 104, 84, 3, 67, 101, manaCost = 42, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 100, 100, 108, 108, 86, 3, 69, 103, manaCost = 43, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 100, 100, 112, 112, 88, 3, 70, 106, manaCost = 44, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 100, 100, 116, 116, 90, 3, 72, 108, manaCost = 45, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["Cleave"] = {
	name = "Cleave",
	color = 1,
	description = "The character swings their weapon (or both weapons if dual wielding) in an arc towards the target. Also does damage to other nearby monsters. Only works with Axes and Swords.",
	skillTypes = { [1] = true, [6] = true, [8] = true, [11] = true, [28] = true, [24] = true, [53] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Thrusting One Handed Sword"] = true,
		["One Handed Axe"] = true,
		["Two Handed Sword"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	statMap = {
		["cleave_damage_+%_final_while_dual_wielding"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Condition", var = "DualWielding" }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 20),
	},
	qualityStats = {
		{ "attack_speed_+%", 0.5 },
	},
	stats = {
		"cleave_damage_+%_final_while_dual_wielding",
		"active_skill_base_radius_+",
		"is_area_damage",
		"skill_double_hits_when_dual_wielding",
	},
	levels = {
		[1] = { -40, 0, damageMultiplier = 10, levelRequirement = 1, manaCost = 6, statInterpolation = { }, },
		[2] = { -40, 0, damageMultiplier = 12.8, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { -40, 1, damageMultiplier = 15.6, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[4] = { -40, 1, damageMultiplier = 18.4, levelRequirement = 7, manaCost = 6, statInterpolation = { }, },
		[5] = { -40, 1, damageMultiplier = 21.2, levelRequirement = 11, manaCost = 6, statInterpolation = { }, },
		[6] = { -40, 2, damageMultiplier = 24, levelRequirement = 16, manaCost = 6, statInterpolation = { }, },
		[7] = { -40, 2, damageMultiplier = 26.8, levelRequirement = 20, manaCost = 6, statInterpolation = { }, },
		[8] = { -40, 2, damageMultiplier = 29.6, levelRequirement = 24, manaCost = 6, statInterpolation = { }, },
		[9] = { -40, 3, damageMultiplier = 32.4, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[10] = { -40, 3, damageMultiplier = 35.2, levelRequirement = 32, manaCost = 6, statInterpolation = { }, },
		[11] = { -40, 3, damageMultiplier = 38, levelRequirement = 36, manaCost = 6, statInterpolation = { }, },
		[12] = { -40, 4, damageMultiplier = 40.8, levelRequirement = 40, manaCost = 6, statInterpolation = { }, },
		[13] = { -40, 4, damageMultiplier = 43.6, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[14] = { -40, 4, damageMultiplier = 46.4, levelRequirement = 48, manaCost = 6, statInterpolation = { }, },
		[15] = { -40, 5, damageMultiplier = 49.2, levelRequirement = 52, manaCost = 6, statInterpolation = { }, },
		[16] = { -40, 5, damageMultiplier = 52, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[17] = { -40, 5, damageMultiplier = 54.8, levelRequirement = 60, manaCost = 6, statInterpolation = { }, },
		[18] = { -40, 6, damageMultiplier = 57.6, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[19] = { -40, 6, damageMultiplier = 60.4, levelRequirement = 67, manaCost = 6, statInterpolation = { }, },
		[20] = { -40, 6, damageMultiplier = 63.2, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { -40, 7, damageMultiplier = 66, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { -40, 7, damageMultiplier = 68.8, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { -40, 7, damageMultiplier = 71.6, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { -40, 8, damageMultiplier = 74.4, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { -40, 8, damageMultiplier = 77.2, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { -40, 8, damageMultiplier = 80, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { -40, 9, damageMultiplier = 82.8, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { -40, 9, damageMultiplier = 85.6, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { -40, 9, damageMultiplier = 88.4, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { -40, 10, damageMultiplier = 91.2, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["DecoyTotem"] = {
	name = "Decoy Totem",
	color = 1,
	description = "Summons a totem that taunts nearby monsters to attack it.",
	skillTypes = { [2] = true, [17] = true, [12] = true, [19] = true, [11] = true, [30] = true, [26] = true, },
	skillTotemId = 6,
	castTime = 1,
	baseFlags = {
		spell = true,
		totem = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		{ "totem_life_+%", 1 },
	},
	stats = {
		"is_totem",
		"base_totem_duration",
		"base_totem_range",
		"base_active_skill_totem_level",
		"totem_life_+%",
		"base_skill_is_totemified",
		"base_deal_no_damage",
		"totems_cannot_evade",
		"totem_ignores_cooldown",
	},
	levels = {
		[1] = { 1, 8000, 60, 4, 0, cooldown = 4, levelRequirement = 4, manaCost = 9, statInterpolation = { }, },
		[2] = { 1, 8000, 60, 6, 2, cooldown = 4, levelRequirement = 6, manaCost = 10, statInterpolation = { }, },
		[3] = { 1, 8000, 60, 9, 4, cooldown = 4, levelRequirement = 9, manaCost = 10, statInterpolation = { }, },
		[4] = { 1, 8000, 60, 12, 6, cooldown = 4, levelRequirement = 12, manaCost = 12, statInterpolation = { }, },
		[5] = { 1, 8000, 60, 15, 8, cooldown = 4, levelRequirement = 16, manaCost = 14, statInterpolation = { }, },
		[6] = { 1, 8000, 60, 19, 10, cooldown = 4, levelRequirement = 20, manaCost = 17, statInterpolation = { }, },
		[7] = { 1, 8000, 60, 23, 12, cooldown = 4, levelRequirement = 24, manaCost = 18, statInterpolation = { }, },
		[8] = { 1, 8000, 60, 28, 14, cooldown = 4, levelRequirement = 28, manaCost = 19, statInterpolation = { }, },
		[9] = { 1, 8000, 60, 33, 16, cooldown = 4, levelRequirement = 32, manaCost = 21, statInterpolation = { }, },
		[10] = { 1, 8000, 60, 39, 18, cooldown = 4, levelRequirement = 36, manaCost = 24, statInterpolation = { }, },
		[11] = { 1, 8000, 60, 43, 20, cooldown = 4, levelRequirement = 40, manaCost = 26, statInterpolation = { }, },
		[12] = { 1, 8000, 60, 46, 22, cooldown = 4, levelRequirement = 44, manaCost = 28, statInterpolation = { }, },
		[13] = { 1, 8000, 60, 49, 24, cooldown = 4, levelRequirement = 48, manaCost = 30, statInterpolation = { }, },
		[14] = { 1, 8000, 60, 52, 26, cooldown = 4, levelRequirement = 52, manaCost = 30, statInterpolation = { }, },
		[15] = { 1, 8000, 60, 55, 28, cooldown = 4, levelRequirement = 55, manaCost = 31, statInterpolation = { }, },
		[16] = { 1, 8000, 60, 58, 30, cooldown = 4, levelRequirement = 58, manaCost = 33, statInterpolation = { }, },
		[17] = { 1, 8000, 60, 61, 32, cooldown = 4, levelRequirement = 61, manaCost = 34, statInterpolation = { }, },
		[18] = { 1, 8000, 60, 64, 34, cooldown = 4, levelRequirement = 64, manaCost = 34, statInterpolation = { }, },
		[19] = { 1, 8000, 60, 66, 36, cooldown = 4, levelRequirement = 67, manaCost = 34, statInterpolation = { }, },
		[20] = { 1, 8000, 60, 68, 38, cooldown = 4, levelRequirement = 70, manaCost = 35, statInterpolation = { }, },
		[21] = { 1, 8000, 60, 70, 40, cooldown = 4, levelRequirement = 72, manaCost = 36, statInterpolation = { }, },
		[22] = { 1, 8000, 60, 72, 42, cooldown = 4, levelRequirement = 74, manaCost = 37, statInterpolation = { }, },
		[23] = { 1, 8000, 60, 74, 44, cooldown = 4, levelRequirement = 76, manaCost = 37, statInterpolation = { }, },
		[24] = { 1, 8000, 60, 76, 46, cooldown = 4, levelRequirement = 78, manaCost = 38, statInterpolation = { }, },
		[25] = { 1, 8000, 60, 78, 48, cooldown = 4, levelRequirement = 80, manaCost = 38, statInterpolation = { }, },
		[26] = { 1, 8000, 60, 80, 50, cooldown = 4, levelRequirement = 82, manaCost = 39, statInterpolation = { }, },
		[27] = { 1, 8000, 60, 82, 52, cooldown = 4, levelRequirement = 84, manaCost = 40, statInterpolation = { }, },
		[28] = { 1, 8000, 60, 84, 54, cooldown = 4, levelRequirement = 86, manaCost = 40, statInterpolation = { }, },
		[29] = { 1, 8000, 60, 86, 56, cooldown = 4, levelRequirement = 88, manaCost = 41, statInterpolation = { }, },
		[30] = { 1, 8000, 60, 88, 58, cooldown = 4, levelRequirement = 90, manaCost = 42, statInterpolation = { }, },
	},
}
skills["Determination"] = {
	name = "Determination",
	color = 1,
	description = "Casts an aura that grants armour to you and your allies.",
	skillTypes = { [2] = true, [11] = true, [5] = true, [15] = true, [27] = true, [16] = true, [18] = true, [44] = true, },
	castTime = 1.2,
	statMap = {
		["determination_aura_armour_+%_final"] = {
			mod("Armour", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"determination_aura_armour_+%_final",
		"base_skill_area_of_effect_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 32, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 50, statInterpolation = { }, },
		[2] = { 33, 3, cooldown = 1.2, levelRequirement = 27, manaCost = 50, statInterpolation = { }, },
		[3] = { 34, 6, cooldown = 1.2, levelRequirement = 30, manaCost = 50, statInterpolation = { }, },
		[4] = { 35, 9, cooldown = 1.2, levelRequirement = 33, manaCost = 50, statInterpolation = { }, },
		[5] = { 36, 12, cooldown = 1.2, levelRequirement = 36, manaCost = 50, statInterpolation = { }, },
		[6] = { 37, 15, cooldown = 1.2, levelRequirement = 39, manaCost = 50, statInterpolation = { }, },
		[7] = { 38, 18, cooldown = 1.2, levelRequirement = 42, manaCost = 50, statInterpolation = { }, },
		[8] = { 39, 21, cooldown = 1.2, levelRequirement = 45, manaCost = 50, statInterpolation = { }, },
		[9] = { 40, 23, cooldown = 1.2, levelRequirement = 48, manaCost = 50, statInterpolation = { }, },
		[10] = { 41, 25, cooldown = 1.2, levelRequirement = 50, manaCost = 50, statInterpolation = { }, },
		[11] = { 42, 27, cooldown = 1.2, levelRequirement = 52, manaCost = 50, statInterpolation = { }, },
		[12] = { 43, 29, cooldown = 1.2, levelRequirement = 54, manaCost = 50, statInterpolation = { }, },
		[13] = { 44, 31, cooldown = 1.2, levelRequirement = 56, manaCost = 50, statInterpolation = { }, },
		[14] = { 45, 33, cooldown = 1.2, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[15] = { 46, 35, cooldown = 1.2, levelRequirement = 60, manaCost = 50, statInterpolation = { }, },
		[16] = { 47, 36, cooldown = 1.2, levelRequirement = 62, manaCost = 50, statInterpolation = { }, },
		[17] = { 48, 37, cooldown = 1.2, levelRequirement = 64, manaCost = 50, statInterpolation = { }, },
		[18] = { 49, 38, cooldown = 1.2, levelRequirement = 66, manaCost = 50, statInterpolation = { }, },
		[19] = { 50, 39, cooldown = 1.2, levelRequirement = 68, manaCost = 50, statInterpolation = { }, },
		[20] = { 51, 40, cooldown = 1.2, levelRequirement = 70, manaCost = 50, statInterpolation = { }, },
		[21] = { 52, 41, cooldown = 1.2, levelRequirement = 72, manaCost = 50, statInterpolation = { }, },
		[22] = { 53, 42, cooldown = 1.2, levelRequirement = 74, manaCost = 50, statInterpolation = { }, },
		[23] = { 54, 43, cooldown = 1.2, levelRequirement = 76, manaCost = 50, statInterpolation = { }, },
		[24] = { 55, 44, cooldown = 1.2, levelRequirement = 78, manaCost = 50, statInterpolation = { }, },
		[25] = { 56, 45, cooldown = 1.2, levelRequirement = 80, manaCost = 50, statInterpolation = { }, },
		[26] = { 57, 46, cooldown = 1.2, levelRequirement = 82, manaCost = 50, statInterpolation = { }, },
		[27] = { 58, 47, cooldown = 1.2, levelRequirement = 84, manaCost = 50, statInterpolation = { }, },
		[28] = { 59, 48, cooldown = 1.2, levelRequirement = 86, manaCost = 50, statInterpolation = { }, },
		[29] = { 60, 49, cooldown = 1.2, levelRequirement = 88, manaCost = 50, statInterpolation = { }, },
		[30] = { 61, 50, cooldown = 1.2, levelRequirement = 90, manaCost = 50, statInterpolation = { }, },
	},
}
skills["DevouringTotem"] = {
	name = "Devouring Totem",
	color = 1,
	description = "Summons a totem that can consume nearby corpses. If you are hurt, it will destroy a corpse to leech life to you.",
	skillTypes = { [2] = true, [17] = true, [12] = true, [19] = true, [30] = true, },
	skillTotemId = 7,
	castTime = 1,
	statMap = {
		["corpse_consumption_life_to_gain"] = {
			skill("lifeLeechPerUse", nil),
		},
		["corpse_consumption_mana_to_gain"] = {
			skill("manaLeechPerUse", nil),
		},
	},
	baseFlags = {
		spell = true,
		totem = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "totem_life_+%", 1 },
	},
	stats = {
		"is_totem",
		"base_totem_duration",
		"base_totem_range",
		"base_active_skill_totem_level",
		"corpse_consumption_life_to_gain",
		"corpse_consumption_mana_to_gain",
		"base_skill_is_totemified",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 1, 8000, 60, 4, 30, 9, manaCost = 20, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 1, 8000, 60, 6, 39, 12, manaCost = 22, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 1, 8000, 60, 9, 45, 14, manaCost = 23, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 1, 8000, 60, 12, 53, 17, manaCost = 25, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 1, 8000, 60, 16, 61, 19, manaCost = 26, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 1, 8000, 60, 20, 70, 22, manaCost = 28, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 1, 8000, 60, 24, 79, 24, manaCost = 30, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 1, 8000, 60, 28, 90, 27, manaCost = 31, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 1, 8000, 60, 32, 102, 29, manaCost = 33, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 1, 8000, 60, 36, 115, 32, manaCost = 34, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 1, 8000, 60, 40, 129, 34, manaCost = 36, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 1, 8000, 60, 44, 144, 37, manaCost = 37, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 1, 8000, 60, 48, 157, 40, manaCost = 38, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 1, 8000, 60, 52, 173, 42, manaCost = 39, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 1, 8000, 60, 55, 191, 45, manaCost = 40, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 1, 8000, 60, 58, 211, 47, manaCost = 41, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 1, 8000, 60, 61, 231, 50, manaCost = 42, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 1, 8000, 60, 64, 253, 53, manaCost = 42, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 1, 8000, 60, 67, 275, 56, manaCost = 43, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 1, 8000, 60, 70, 299, 59, manaCost = 44, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 1, 8000, 60, 72, 325, 62, manaCost = 45, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 1, 8000, 60, 74, 352, 66, manaCost = 45, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 1, 8000, 60, 76, 382, 69, manaCost = 46, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 1, 8000, 60, 78, 413, 73, manaCost = 46, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 1, 8000, 60, 80, 447, 76, manaCost = 47, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 1, 8000, 60, 82, 483, 80, manaCost = 48, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 1, 8000, 60, 84, 522, 84, manaCost = 49, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 1, 8000, 60, 86, 563, 88, manaCost = 50, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 1, 8000, 60, 88, 606, 92, manaCost = 50, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 1, 8000, 60, 90, 652, 96, manaCost = 51, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["DominatingBlow"] = {
	name = "Dominating Blow",
	color = 1,
	description = "Attacks the enemy with a melee strike. If a non-unique enemy is killed shortly after being hit by Dominating Blow, that enemy is revived as a minion until the skill duration ends.",
	skillTypes = { [1] = true, [6] = true, [9] = true, [12] = true, [21] = true, [25] = true, [28] = true, [24] = true, },
	minionSkillTypes = { [1] = true, [24] = true, [25] = true, [28] = true, [2] = true, [10] = true, [11] = true, [3] = true, [23] = true, [12] = true, [30] = true, [37] = true, [41] = true, [40] = true, [58] = true, [32] = true, [48] = true, [26] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "damage_+%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_minion_damage_+%_final",
		"is_dominated",
	},
	levels = {
		[1] = { 20000, -35, damageMultiplier = 25, levelRequirement = 28, manaCost = 12, statInterpolation = { }, },
		[2] = { 20000, -35, damageMultiplier = 27.1, levelRequirement = 31, manaCost = 12, statInterpolation = { }, },
		[3] = { 20000, -35, damageMultiplier = 29.2, levelRequirement = 34, manaCost = 12, statInterpolation = { }, },
		[4] = { 20000, -35, damageMultiplier = 31.3, levelRequirement = 37, manaCost = 13, statInterpolation = { }, },
		[5] = { 20000, -35, damageMultiplier = 33.4, levelRequirement = 40, manaCost = 13, statInterpolation = { }, },
		[6] = { 20000, -35, damageMultiplier = 35.5, levelRequirement = 42, manaCost = 13, statInterpolation = { }, },
		[7] = { 20000, -35, damageMultiplier = 37.6, levelRequirement = 44, manaCost = 14, statInterpolation = { }, },
		[8] = { 20000, -35, damageMultiplier = 39.7, levelRequirement = 46, manaCost = 14, statInterpolation = { }, },
		[9] = { 20000, -35, damageMultiplier = 41.8, levelRequirement = 48, manaCost = 14, statInterpolation = { }, },
		[10] = { 20000, -35, damageMultiplier = 43.9, levelRequirement = 50, manaCost = 14, statInterpolation = { }, },
		[11] = { 20000, -35, damageMultiplier = 46, levelRequirement = 52, manaCost = 14, statInterpolation = { }, },
		[12] = { 20000, -35, damageMultiplier = 48.1, levelRequirement = 54, manaCost = 15, statInterpolation = { }, },
		[13] = { 20000, -35, damageMultiplier = 50.2, levelRequirement = 56, manaCost = 15, statInterpolation = { }, },
		[14] = { 20000, -35, damageMultiplier = 52.3, levelRequirement = 58, manaCost = 15, statInterpolation = { }, },
		[15] = { 20000, -35, damageMultiplier = 54.4, levelRequirement = 60, manaCost = 15, statInterpolation = { }, },
		[16] = { 20000, -35, damageMultiplier = 56.5, levelRequirement = 62, manaCost = 15, statInterpolation = { }, },
		[17] = { 20000, -35, damageMultiplier = 58.6, levelRequirement = 64, manaCost = 15, statInterpolation = { }, },
		[18] = { 20000, -35, damageMultiplier = 60.7, levelRequirement = 66, manaCost = 15, statInterpolation = { }, },
		[19] = { 20000, -35, damageMultiplier = 62.8, levelRequirement = 68, manaCost = 15, statInterpolation = { }, },
		[20] = { 20000, -35, damageMultiplier = 64.9, levelRequirement = 70, manaCost = 16, statInterpolation = { }, },
		[21] = { 20000, -35, damageMultiplier = 67, levelRequirement = 72, manaCost = 16, statInterpolation = { }, },
		[22] = { 20000, -35, damageMultiplier = 69.1, levelRequirement = 74, manaCost = 16, statInterpolation = { }, },
		[23] = { 20000, -35, damageMultiplier = 71.2, levelRequirement = 76, manaCost = 16, statInterpolation = { }, },
		[24] = { 20000, -35, damageMultiplier = 73.3, levelRequirement = 78, manaCost = 16, statInterpolation = { }, },
		[25] = { 20000, -35, damageMultiplier = 75.4, levelRequirement = 80, manaCost = 16, statInterpolation = { }, },
		[26] = { 20000, -35, damageMultiplier = 77.5, levelRequirement = 82, manaCost = 17, statInterpolation = { }, },
		[27] = { 20000, -35, damageMultiplier = 79.6, levelRequirement = 84, manaCost = 17, statInterpolation = { }, },
		[28] = { 20000, -35, damageMultiplier = 81.7, levelRequirement = 86, manaCost = 17, statInterpolation = { }, },
		[29] = { 20000, -35, damageMultiplier = 83.8, levelRequirement = 88, manaCost = 17, statInterpolation = { }, },
		[30] = { 20000, -35, damageMultiplier = 85.9, levelRequirement = 90, manaCost = 17, statInterpolation = { }, },
	},
}
skills["Earthquake"] = {
	name = "Earthquake",
	color = 1,
	description = "Smashes the ground with an Axe, Mace or Staff, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a short duration. Earthquakes created before the first one has erupted will not generate their own aftershocks.",
	skillTypes = { [1] = true, [6] = true, [11] = true, [24] = true, [7] = true, [10] = true, [28] = true, [12] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Two Handed Axe"] = true,
		["Staff"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Initial impact",
		},
		{
			name = "Aftershock",
		},
	},
	statMap = {
		["quake_slam_fully_charged_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 18, { type = "SkillPart", skillPart = 1 }),
		skill("radius", 25, { type = "SkillPart", skillPart = 2 }),
	},
	qualityStats = {
		{ "physical_damage_+%", 1 },
	},
	stats = {
		"base_skill_effect_duration",
		"quake_slam_fully_charged_explosion_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 1500, 50, damageMultiplier = -10, levelRequirement = 28, manaCost = 10, statInterpolation = { }, },
		[2] = { 1500, 50, damageMultiplier = -9, levelRequirement = 31, manaCost = 10, statInterpolation = { }, },
		[3] = { 1500, 50, damageMultiplier = -8, levelRequirement = 34, manaCost = 10, statInterpolation = { }, },
		[4] = { 1500, 50, damageMultiplier = -7, levelRequirement = 37, manaCost = 10, statInterpolation = { }, },
		[5] = { 1500, 50, damageMultiplier = -6, levelRequirement = 40, manaCost = 10, statInterpolation = { }, },
		[6] = { 1500, 50, damageMultiplier = -5, levelRequirement = 42, manaCost = 10, statInterpolation = { }, },
		[7] = { 1500, 50, damageMultiplier = -4, levelRequirement = 44, manaCost = 10, statInterpolation = { }, },
		[8] = { 1500, 50, damageMultiplier = -3, levelRequirement = 46, manaCost = 10, statInterpolation = { }, },
		[9] = { 1500, 50, damageMultiplier = -2, levelRequirement = 48, manaCost = 10, statInterpolation = { }, },
		[10] = { 1500, 50, damageMultiplier = -1, levelRequirement = 50, manaCost = 10, statInterpolation = { }, },
		[11] = { 1500, 50, manaCost = 10, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 1500, 50, damageMultiplier = 1, levelRequirement = 54, manaCost = 10, statInterpolation = { }, },
		[13] = { 1500, 50, damageMultiplier = 2, levelRequirement = 56, manaCost = 10, statInterpolation = { }, },
		[14] = { 1500, 50, damageMultiplier = 3, levelRequirement = 58, manaCost = 10, statInterpolation = { }, },
		[15] = { 1500, 50, damageMultiplier = 4, levelRequirement = 60, manaCost = 10, statInterpolation = { }, },
		[16] = { 1500, 50, damageMultiplier = 5, levelRequirement = 62, manaCost = 10, statInterpolation = { }, },
		[17] = { 1500, 50, damageMultiplier = 6, levelRequirement = 64, manaCost = 10, statInterpolation = { }, },
		[18] = { 1500, 50, damageMultiplier = 7, levelRequirement = 66, manaCost = 10, statInterpolation = { }, },
		[19] = { 1500, 50, damageMultiplier = 8, levelRequirement = 68, manaCost = 10, statInterpolation = { }, },
		[20] = { 1500, 50, damageMultiplier = 9, levelRequirement = 70, manaCost = 10, statInterpolation = { }, },
		[21] = { 1500, 50, damageMultiplier = 10, levelRequirement = 72, manaCost = 10, statInterpolation = { }, },
		[22] = { 1500, 50, damageMultiplier = 11, levelRequirement = 74, manaCost = 10, statInterpolation = { }, },
		[23] = { 1500, 50, damageMultiplier = 12, levelRequirement = 76, manaCost = 10, statInterpolation = { }, },
		[24] = { 1500, 50, damageMultiplier = 13, levelRequirement = 78, manaCost = 10, statInterpolation = { }, },
		[25] = { 1500, 50, damageMultiplier = 14, levelRequirement = 80, manaCost = 10, statInterpolation = { }, },
		[26] = { 1500, 50, damageMultiplier = 15, levelRequirement = 82, manaCost = 10, statInterpolation = { }, },
		[27] = { 1500, 50, damageMultiplier = 16, levelRequirement = 84, manaCost = 10, statInterpolation = { }, },
		[28] = { 1500, 50, damageMultiplier = 17, levelRequirement = 86, manaCost = 10, statInterpolation = { }, },
		[29] = { 1500, 50, damageMultiplier = 18, levelRequirement = 88, manaCost = 10, statInterpolation = { }, },
		[30] = { 1500, 50, damageMultiplier = 19, levelRequirement = 90, manaCost = 10, statInterpolation = { }, },
	},
}
skills["EnduringCry"] = {
	name = "Enduring Cry",
	color = 1,
	description = "Performs a warcry, adding endurance charges proportional to the number of surrounding enemies and granting life regeneration to you for a short time if there are nearby enemies. Taunts all nearby enemies to attack the user. Shares a cooldown with other Warcry skills.",
	skillTypes = { [5] = true, [11] = true, [12] = true, },
	castTime = 0.25,
	statMap = {
		["base_life_regeneration_rate_per_minute"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 3 },
	},
	stats = {
		"endurance_charges_granted_per_one_hundred_nearby_enemies_during_endurance_warcry",
		"base_skill_effect_duration",
		"base_life_regeneration_rate_per_minute",
		"is_warcry",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 8, 750, 2880, cooldown = 4, levelRequirement = 16, manaCost = 17, statInterpolation = { }, },
		[2] = { 10, 750, 3720, cooldown = 4, levelRequirement = 20, manaCost = 17, statInterpolation = { }, },
		[3] = { 12, 750, 4560, cooldown = 4, levelRequirement = 24, manaCost = 17, statInterpolation = { }, },
		[4] = { 14, 750, 5640, cooldown = 4, levelRequirement = 28, manaCost = 17, statInterpolation = { }, },
		[5] = { 16, 750, 6480, cooldown = 4, levelRequirement = 31, manaCost = 18, statInterpolation = { }, },
		[6] = { 18, 750, 7320, cooldown = 4, levelRequirement = 34, manaCost = 18, statInterpolation = { }, },
		[7] = { 20, 750, 8400, cooldown = 4, levelRequirement = 37, manaCost = 18, statInterpolation = { }, },
		[8] = { 22, 750, 9480, cooldown = 4, levelRequirement = 40, manaCost = 19, statInterpolation = { }, },
		[9] = { 24, 750, 10560, cooldown = 4, levelRequirement = 43, manaCost = 19, statInterpolation = { }, },
		[10] = { 26, 750, 11760, cooldown = 4, levelRequirement = 46, manaCost = 19, statInterpolation = { }, },
		[11] = { 27, 750, 12960, cooldown = 4, levelRequirement = 49, manaCost = 20, statInterpolation = { }, },
		[12] = { 28, 750, 14280, cooldown = 4, levelRequirement = 52, manaCost = 20, statInterpolation = { }, },
		[13] = { 29, 750, 15720, cooldown = 4, levelRequirement = 55, manaCost = 20, statInterpolation = { }, },
		[14] = { 30, 750, 17160, cooldown = 4, levelRequirement = 58, manaCost = 20, statInterpolation = { }, },
		[15] = { 31, 750, 18120, cooldown = 4, levelRequirement = 60, manaCost = 20, statInterpolation = { }, },
		[16] = { 32, 750, 19200, cooldown = 4, levelRequirement = 62, manaCost = 21, statInterpolation = { }, },
		[17] = { 33, 750, 20280, cooldown = 4, levelRequirement = 64, manaCost = 21, statInterpolation = { }, },
		[18] = { 34, 750, 21360, cooldown = 4, levelRequirement = 66, manaCost = 21, statInterpolation = { }, },
		[19] = { 35, 750, 22440, cooldown = 4, levelRequirement = 68, manaCost = 21, statInterpolation = { }, },
		[20] = { 36, 750, 23640, cooldown = 4, levelRequirement = 70, manaCost = 21, statInterpolation = { }, },
		[21] = { 37, 750, 24840, cooldown = 4, levelRequirement = 72, manaCost = 22, statInterpolation = { }, },
		[22] = { 38, 750, 26040, cooldown = 4, levelRequirement = 74, manaCost = 22, statInterpolation = { }, },
		[23] = { 39, 750, 27240, cooldown = 4, levelRequirement = 76, manaCost = 22, statInterpolation = { }, },
		[24] = { 40, 750, 28560, cooldown = 4, levelRequirement = 78, manaCost = 22, statInterpolation = { }, },
		[25] = { 41, 750, 29880, cooldown = 4, levelRequirement = 80, manaCost = 22, statInterpolation = { }, },
		[26] = { 42, 750, 31200, cooldown = 4, levelRequirement = 82, manaCost = 23, statInterpolation = { }, },
		[27] = { 43, 750, 32640, cooldown = 4, levelRequirement = 84, manaCost = 23, statInterpolation = { }, },
		[28] = { 44, 750, 33960, cooldown = 4, levelRequirement = 86, manaCost = 23, statInterpolation = { }, },
		[29] = { 45, 750, 35400, cooldown = 4, levelRequirement = 88, manaCost = 23, statInterpolation = { }, },
		[30] = { 46, 750, 36840, cooldown = 4, levelRequirement = 90, manaCost = 23, statInterpolation = { }, },
	},
}
skills["FlameTotem"] = {
	name = "Flame Totem",
	color = 1,
	description = "Summons a totem that fires a stream of flame at nearby enemies.",
	skillTypes = { [2] = true, [3] = true, [10] = true, [12] = true, [17] = true, [19] = true, [30] = true, [33] = true, },
	skillTotemId = 8,
	castTime = 0.25,
	baseFlags = {
		spell = true,
		totem = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "totem_life_+%", 1 },
	},
	stats = {
		"base_totem_duration",
		"base_totem_range",
		"base_active_skill_totem_level",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"number_of_additional_projectiles",
		"is_totem",
		"base_skill_is_totemified",
		"base_is_projectile",
		"always_pierce",
	},
	levels = {
		[1] = { 8000, 100, 4, 1, 2, 0, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 4, manaCost = 12, statInterpolation = { }, },
		[2] = { 8000, 100, 6, 1, 3, 0, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 6, manaCost = 14, statInterpolation = { }, },
		[3] = { 8000, 100, 9, 2, 4, 0, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 9, manaCost = 16, statInterpolation = { }, },
		[4] = { 8000, 100, 12, 3, 5, 0, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 12, manaCost = 17, statInterpolation = { }, },
		[5] = { 8000, 100, 16, 4, 7, 1, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 16, manaCost = 19, statInterpolation = { }, },
		[6] = { 8000, 100, 20, 6, 10, 1, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 20, manaCost = 21, statInterpolation = { }, },
		[7] = { 8000, 100, 24, 9, 13, 1, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 24, manaCost = 23, statInterpolation = { }, },
		[8] = { 8000, 100, 28, 11, 17, 1, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 28, manaCost = 24, statInterpolation = { }, },
		[9] = { 8000, 100, 32, 14, 22, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 32, manaCost = 26, statInterpolation = { }, },
		[10] = { 8000, 100, 36, 18, 28, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 36, manaCost = 29, statInterpolation = { }, },
		[11] = { 8000, 100, 40, 24, 35, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 40, manaCost = 31, statInterpolation = { }, },
		[12] = { 8000, 100, 44, 30, 45, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 44, manaCost = 32, statInterpolation = { }, },
		[13] = { 8000, 100, 48, 37, 56, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 48, manaCost = 33, statInterpolation = { }, },
		[14] = { 8000, 100, 52, 47, 70, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 52, manaCost = 34, statInterpolation = { }, },
		[15] = { 8000, 100, 55, 55, 83, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 55, manaCost = 36, statInterpolation = { }, },
		[16] = { 8000, 100, 58, 65, 97, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 58, manaCost = 37, statInterpolation = { }, },
		[17] = { 8000, 100, 61, 76, 114, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 61, manaCost = 39, statInterpolation = { }, },
		[18] = { 8000, 100, 64, 89, 134, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 64, manaCost = 40, statInterpolation = { }, },
		[19] = { 8000, 100, 67, 105, 157, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 67, manaCost = 41, statInterpolation = { }, },
		[20] = { 8000, 100, 70, 122, 183, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 70, manaCost = 42, statInterpolation = { }, },
		[21] = { 8000, 100, 72, 136, 203, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 72, manaCost = 43, statInterpolation = { }, },
		[22] = { 8000, 100, 74, 150, 225, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 74, manaCost = 44, statInterpolation = { }, },
		[23] = { 8000, 100, 76, 166, 249, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 76, manaCost = 45, statInterpolation = { }, },
		[24] = { 8000, 100, 78, 184, 276, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 78, manaCost = 46, statInterpolation = { }, },
		[25] = { 8000, 100, 80, 204, 305, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 80, manaCost = 47, statInterpolation = { }, },
		[26] = { 8000, 100, 82, 225, 338, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 82, manaCost = 48, statInterpolation = { }, },
		[27] = { 8000, 100, 84, 249, 373, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 84, manaCost = 49, statInterpolation = { }, },
		[28] = { 8000, 100, 86, 275, 412, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 86, manaCost = 50, statInterpolation = { }, },
		[29] = { 8000, 100, 88, 303, 455, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 88, manaCost = 51, statInterpolation = { }, },
		[30] = { 8000, 100, 90, 335, 502, 2, damageEffectiveness = 0.25, critChance = 5, levelRequirement = 90, manaCost = 52, statInterpolation = { }, },
	},
}
skills["GlacialHammer"] = {
	name = "Glacial Hammer",
	color = 1,
	description = "Hits the enemy, converting some of your physical damage to cold damage. If the enemy is frozen and is on less than one third life, they will shatter when hit by Glacial Hammer. Requires a Mace or Staff.",
	skillTypes = { [1] = true, [6] = true, [25] = true, [28] = true, [24] = true, [34] = true, [53] = true, },
	weaponTypes = {
		["Two Handed Mace"] = true,
		["Staff"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "chill_duration_+%", 2 },
		{ "freeze_duration_+%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"base_chance_to_freeze_%",
		"chill_duration_+%",
	},
	levels = {
		[1] = { 50, 25, 35, damageMultiplier = 40, levelRequirement = 1, manaCost = 5, statInterpolation = { }, },
		[2] = { 50, 25, 35, damageMultiplier = 42.2, levelRequirement = 2, manaCost = 5, statInterpolation = { }, },
		[3] = { 50, 25, 35, damageMultiplier = 44.4, levelRequirement = 4, manaCost = 5, statInterpolation = { }, },
		[4] = { 50, 25, 35, damageMultiplier = 46.6, levelRequirement = 7, manaCost = 5, statInterpolation = { }, },
		[5] = { 50, 25, 35, damageMultiplier = 48.8, levelRequirement = 11, manaCost = 5, statInterpolation = { }, },
		[6] = { 50, 25, 35, damageMultiplier = 51, levelRequirement = 16, manaCost = 5, statInterpolation = { }, },
		[7] = { 50, 25, 35, damageMultiplier = 53.2, levelRequirement = 20, manaCost = 5, statInterpolation = { }, },
		[8] = { 50, 25, 35, damageMultiplier = 55.4, levelRequirement = 24, manaCost = 5, statInterpolation = { }, },
		[9] = { 50, 25, 35, damageMultiplier = 57.6, levelRequirement = 28, manaCost = 5, statInterpolation = { }, },
		[10] = { 50, 25, 35, damageMultiplier = 59.8, levelRequirement = 32, manaCost = 5, statInterpolation = { }, },
		[11] = { 50, 25, 35, damageMultiplier = 62, levelRequirement = 36, manaCost = 5, statInterpolation = { }, },
		[12] = { 50, 25, 35, damageMultiplier = 64.2, levelRequirement = 40, manaCost = 5, statInterpolation = { }, },
		[13] = { 50, 25, 35, damageMultiplier = 66.4, levelRequirement = 44, manaCost = 5, statInterpolation = { }, },
		[14] = { 50, 25, 35, damageMultiplier = 68.6, levelRequirement = 48, manaCost = 5, statInterpolation = { }, },
		[15] = { 50, 25, 35, damageMultiplier = 70.8, levelRequirement = 52, manaCost = 5, statInterpolation = { }, },
		[16] = { 50, 25, 35, damageMultiplier = 73, levelRequirement = 56, manaCost = 5, statInterpolation = { }, },
		[17] = { 50, 25, 35, damageMultiplier = 75.2, levelRequirement = 60, manaCost = 5, statInterpolation = { }, },
		[18] = { 50, 25, 35, damageMultiplier = 77.4, levelRequirement = 64, manaCost = 5, statInterpolation = { }, },
		[19] = { 50, 25, 35, damageMultiplier = 79.6, levelRequirement = 67, manaCost = 5, statInterpolation = { }, },
		[20] = { 50, 25, 35, damageMultiplier = 81.8, levelRequirement = 70, manaCost = 5, statInterpolation = { }, },
		[21] = { 50, 25, 35, damageMultiplier = 84, levelRequirement = 72, manaCost = 5, statInterpolation = { }, },
		[22] = { 50, 25, 35, damageMultiplier = 86.2, levelRequirement = 74, manaCost = 5, statInterpolation = { }, },
		[23] = { 50, 25, 35, damageMultiplier = 88.4, levelRequirement = 76, manaCost = 5, statInterpolation = { }, },
		[24] = { 50, 25, 35, damageMultiplier = 90.6, levelRequirement = 78, manaCost = 5, statInterpolation = { }, },
		[25] = { 50, 25, 35, damageMultiplier = 92.8, levelRequirement = 80, manaCost = 5, statInterpolation = { }, },
		[26] = { 50, 25, 35, damageMultiplier = 95, levelRequirement = 82, manaCost = 5, statInterpolation = { }, },
		[27] = { 50, 25, 35, damageMultiplier = 97.2, levelRequirement = 84, manaCost = 5, statInterpolation = { }, },
		[28] = { 50, 25, 35, damageMultiplier = 99.4, levelRequirement = 86, manaCost = 5, statInterpolation = { }, },
		[29] = { 50, 25, 35, damageMultiplier = 101.6, levelRequirement = 88, manaCost = 5, statInterpolation = { }, },
		[30] = { 50, 25, 35, damageMultiplier = 103.8, levelRequirement = 90, manaCost = 5, statInterpolation = { }, },
	},
}
skills["VaalGlacialHammer"] = {
	name = "Vaal Glacial Hammer",
	color = 1,
	description = "Hits the enemy, converting some of your physical damage to cold damage. It traps the enemy with you in a circle of ice so that it can't escape. Requires a Mace or Staff.",
	skillTypes = { [1] = true, [6] = true, [25] = true, [28] = true, [24] = true, [12] = true, [11] = true, [43] = true, [34] = true, },
	weaponTypes = {
		["Two Handed Mace"] = true,
		["Staff"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "chill_duration_+%", 2 },
		{ "freeze_duration_+%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"base_chance_to_freeze_%",
		"chill_duration_+%",
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 50, 25, 35, 3400, damageMultiplier = 50, levelRequirement = 1, statInterpolation = { }, },
		[2] = { 50, 25, 35, 3450, damageMultiplier = 51.8, levelRequirement = 2, statInterpolation = { }, },
		[3] = { 50, 25, 35, 3500, damageMultiplier = 53.6, levelRequirement = 4, statInterpolation = { }, },
		[4] = { 50, 25, 35, 3550, damageMultiplier = 55.4, levelRequirement = 7, statInterpolation = { }, },
		[5] = { 50, 25, 35, 3600, damageMultiplier = 57.2, levelRequirement = 11, statInterpolation = { }, },
		[6] = { 50, 25, 35, 3650, damageMultiplier = 59, levelRequirement = 16, statInterpolation = { }, },
		[7] = { 50, 25, 35, 3700, damageMultiplier = 60.8, levelRequirement = 20, statInterpolation = { }, },
		[8] = { 50, 25, 35, 3750, damageMultiplier = 62.6, levelRequirement = 24, statInterpolation = { }, },
		[9] = { 50, 25, 35, 3800, damageMultiplier = 64.4, levelRequirement = 28, statInterpolation = { }, },
		[10] = { 50, 25, 35, 3850, damageMultiplier = 66.2, levelRequirement = 32, statInterpolation = { }, },
		[11] = { 50, 25, 35, 3900, damageMultiplier = 68, levelRequirement = 36, statInterpolation = { }, },
		[12] = { 50, 25, 35, 3950, damageMultiplier = 69.8, levelRequirement = 40, statInterpolation = { }, },
		[13] = { 50, 25, 35, 4000, damageMultiplier = 71.6, levelRequirement = 44, statInterpolation = { }, },
		[14] = { 50, 25, 35, 4050, damageMultiplier = 73.4, levelRequirement = 48, statInterpolation = { }, },
		[15] = { 50, 25, 35, 4100, damageMultiplier = 75.2, levelRequirement = 52, statInterpolation = { }, },
		[16] = { 50, 25, 35, 4150, damageMultiplier = 77, levelRequirement = 56, statInterpolation = { }, },
		[17] = { 50, 25, 35, 4200, damageMultiplier = 78.8, levelRequirement = 60, statInterpolation = { }, },
		[18] = { 50, 25, 35, 4250, damageMultiplier = 80.6, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 50, 25, 35, 4300, damageMultiplier = 82.4, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 50, 25, 35, 4350, damageMultiplier = 84.2, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 50, 25, 35, 4400, damageMultiplier = 86, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 50, 25, 35, 4450, damageMultiplier = 87.8, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 50, 25, 35, 4500, damageMultiplier = 89.6, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 50, 25, 35, 4550, damageMultiplier = 91.4, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 50, 25, 35, 4600, damageMultiplier = 93.2, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 50, 25, 35, 4650, damageMultiplier = 95, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 50, 25, 35, 4700, damageMultiplier = 96.8, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 50, 25, 35, 4750, damageMultiplier = 98.6, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 50, 25, 35, 4800, damageMultiplier = 100.4, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 50, 25, 35, 4850, damageMultiplier = 102.2, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["GroundSlam"] = {
	name = "Ground Slam",
	color = 1,
	description = "The character slams the ground in front of them with their main hand weapon, creating a wave that travels forward and damages enemies with an increased chance to stun. Only works with Staves or Maces.",
	skillTypes = { [1] = true, [6] = true, [7] = true, [11] = true, [28] = true, [24] = true, },
	weaponTypes = {
		["Two Handed Mace"] = true,
		["Staff"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 35),
	},
	qualityStats = {
		{ "base_stun_duration_+%", 1.5 },
	},
	stats = {
		"base_stun_threshold_reduction_+%",
		"active_skill_base_radius_+",
		"is_area_damage",
	},
	levels = {
		[1] = { 25, 0, damageMultiplier = -10, levelRequirement = 1, manaCost = 6, statInterpolation = { }, },
		[2] = { 25, 0, damageMultiplier = -8.4, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { 25, 1, damageMultiplier = -6.8, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[4] = { 25, 1, damageMultiplier = -5.2, levelRequirement = 7, manaCost = 6, statInterpolation = { }, },
		[5] = { 25, 1, damageMultiplier = -3.6, levelRequirement = 11, manaCost = 6, statInterpolation = { }, },
		[6] = { 25, 2, damageMultiplier = -2, levelRequirement = 16, manaCost = 6, statInterpolation = { }, },
		[7] = { 25, 2, damageMultiplier = -0.4, levelRequirement = 20, manaCost = 6, statInterpolation = { }, },
		[8] = { 25, 2, damageMultiplier = 1.2, levelRequirement = 24, manaCost = 6, statInterpolation = { }, },
		[9] = { 25, 3, damageMultiplier = 2.8, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[10] = { 25, 3, damageMultiplier = 4.4, levelRequirement = 32, manaCost = 6, statInterpolation = { }, },
		[11] = { 25, 3, damageMultiplier = 6, levelRequirement = 36, manaCost = 6, statInterpolation = { }, },
		[12] = { 25, 4, damageMultiplier = 7.6, levelRequirement = 40, manaCost = 6, statInterpolation = { }, },
		[13] = { 25, 4, damageMultiplier = 9.2, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[14] = { 25, 4, damageMultiplier = 10.8, levelRequirement = 48, manaCost = 6, statInterpolation = { }, },
		[15] = { 25, 5, damageMultiplier = 12.4, levelRequirement = 52, manaCost = 6, statInterpolation = { }, },
		[16] = { 25, 5, damageMultiplier = 14, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[17] = { 25, 5, damageMultiplier = 15.6, levelRequirement = 60, manaCost = 6, statInterpolation = { }, },
		[18] = { 25, 6, damageMultiplier = 17.2, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[19] = { 25, 6, damageMultiplier = 18.8, levelRequirement = 67, manaCost = 6, statInterpolation = { }, },
		[20] = { 25, 6, damageMultiplier = 20.4, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 25, 7, damageMultiplier = 22, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 25, 7, damageMultiplier = 23.6, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 25, 7, damageMultiplier = 25.2, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 25, 8, damageMultiplier = 26.8, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 25, 8, damageMultiplier = 28.4, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 25, 8, damageMultiplier = 30, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 25, 9, damageMultiplier = 31.6, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 25, 9, damageMultiplier = 33.2, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 25, 9, damageMultiplier = 34.8, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 25, 10, damageMultiplier = 36.4, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["VaalGroundSlam"] = {
	name = "Vaal Ground Slam",
	color = 1,
	description = "The character slams the ground with their main hand weapon, creating a wave that travels in all directions and damages enemies. Only works with Staves or Maces.",
	skillTypes = { [1] = true, [6] = true, [7] = true, [11] = true, [28] = true, [24] = true, [43] = true, },
	weaponTypes = {
		["Two Handed Mace"] = true,
		["Staff"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_stun_duration_+%", 1.5 },
	},
	stats = {
		"knockback_distance_+%",
		"animation_effect_variation",
		"base_skill_area_of_effect_+%",
		"always_stun",
		"global_knockback",
		"is_area_damage",
		"global_always_hit",
	},
	levels = {
		[1] = { 100, -1, 20, damageMultiplier = 60, levelRequirement = 1, statInterpolation = { }, },
		[2] = { 100, -1, 20, damageMultiplier = 62, levelRequirement = 2, statInterpolation = { }, },
		[3] = { 100, -1, 20, damageMultiplier = 64, levelRequirement = 4, statInterpolation = { }, },
		[4] = { 100, -1, 20, damageMultiplier = 66, levelRequirement = 7, statInterpolation = { }, },
		[5] = { 100, -1, 20, damageMultiplier = 68, levelRequirement = 11, statInterpolation = { }, },
		[6] = { 100, -1, 20, damageMultiplier = 70, levelRequirement = 16, statInterpolation = { }, },
		[7] = { 100, -1, 20, damageMultiplier = 72, levelRequirement = 20, statInterpolation = { }, },
		[8] = { 100, -1, 20, damageMultiplier = 74, levelRequirement = 24, statInterpolation = { }, },
		[9] = { 100, -1, 20, damageMultiplier = 76, levelRequirement = 28, statInterpolation = { }, },
		[10] = { 100, -1, 20, damageMultiplier = 78, levelRequirement = 32, statInterpolation = { }, },
		[11] = { 100, -1, 20, damageMultiplier = 80, levelRequirement = 36, statInterpolation = { }, },
		[12] = { 100, -1, 20, damageMultiplier = 82, levelRequirement = 40, statInterpolation = { }, },
		[13] = { 100, -1, 20, damageMultiplier = 84, levelRequirement = 44, statInterpolation = { }, },
		[14] = { 100, -1, 20, damageMultiplier = 86, levelRequirement = 48, statInterpolation = { }, },
		[15] = { 100, -1, 20, damageMultiplier = 88, levelRequirement = 52, statInterpolation = { }, },
		[16] = { 100, -1, 20, damageMultiplier = 90, levelRequirement = 56, statInterpolation = { }, },
		[17] = { 100, -1, 20, damageMultiplier = 92, levelRequirement = 60, statInterpolation = { }, },
		[18] = { 100, -1, 20, damageMultiplier = 94, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 100, -1, 20, damageMultiplier = 96, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 100, -1, 20, damageMultiplier = 98, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 100, -1, 20, damageMultiplier = 100, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 100, -1, 20, damageMultiplier = 102, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 100, -1, 20, damageMultiplier = 104, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 100, -1, 20, damageMultiplier = 106, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 100, -1, 20, damageMultiplier = 108, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 100, -1, 20, damageMultiplier = 110, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 100, -1, 20, damageMultiplier = 112, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 100, -1, 20, damageMultiplier = 114, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 100, -1, 20, damageMultiplier = 116, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 100, -1, 20, damageMultiplier = 118, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["HeavyStrike"] = {
	name = "Heavy Strike",
	color = 1,
	description = "Attacks the enemy with a forceful blow, knocking them back. Requires a Mace, Axe, Sword or Two-Handed Weapon.",
	skillTypes = { [1] = true, [6] = true, [25] = true, [28] = true, [24] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_stun_duration_+%", 1 },
	},
	stats = {
		"global_knockback",
		"base_stun_threshold_reduction_+%",
	},
	levels = {
		[1] = { 1, 25, damageMultiplier = 50, levelRequirement = 1, manaCost = 5, statInterpolation = { }, },
		[2] = { 1, 25, damageMultiplier = 52.3, levelRequirement = 2, manaCost = 5, statInterpolation = { }, },
		[3] = { 1, 25, damageMultiplier = 54.6, levelRequirement = 4, manaCost = 5, statInterpolation = { }, },
		[4] = { 1, 25, damageMultiplier = 56.9, levelRequirement = 7, manaCost = 5, statInterpolation = { }, },
		[5] = { 1, 25, damageMultiplier = 59.2, levelRequirement = 11, manaCost = 5, statInterpolation = { }, },
		[6] = { 1, 25, damageMultiplier = 61.5, levelRequirement = 16, manaCost = 5, statInterpolation = { }, },
		[7] = { 1, 25, damageMultiplier = 63.8, levelRequirement = 20, manaCost = 5, statInterpolation = { }, },
		[8] = { 1, 25, damageMultiplier = 66.1, levelRequirement = 24, manaCost = 5, statInterpolation = { }, },
		[9] = { 1, 25, damageMultiplier = 68.4, levelRequirement = 28, manaCost = 5, statInterpolation = { }, },
		[10] = { 1, 25, damageMultiplier = 70.7, levelRequirement = 32, manaCost = 5, statInterpolation = { }, },
		[11] = { 1, 25, damageMultiplier = 73, levelRequirement = 36, manaCost = 5, statInterpolation = { }, },
		[12] = { 1, 25, damageMultiplier = 75.3, levelRequirement = 40, manaCost = 5, statInterpolation = { }, },
		[13] = { 1, 25, damageMultiplier = 77.6, levelRequirement = 44, manaCost = 5, statInterpolation = { }, },
		[14] = { 1, 25, damageMultiplier = 79.9, levelRequirement = 48, manaCost = 5, statInterpolation = { }, },
		[15] = { 1, 25, damageMultiplier = 82.2, levelRequirement = 52, manaCost = 5, statInterpolation = { }, },
		[16] = { 1, 25, damageMultiplier = 84.5, levelRequirement = 56, manaCost = 5, statInterpolation = { }, },
		[17] = { 1, 25, damageMultiplier = 86.8, levelRequirement = 60, manaCost = 5, statInterpolation = { }, },
		[18] = { 1, 25, damageMultiplier = 89.1, levelRequirement = 64, manaCost = 5, statInterpolation = { }, },
		[19] = { 1, 25, damageMultiplier = 91.4, levelRequirement = 67, manaCost = 5, statInterpolation = { }, },
		[20] = { 1, 25, damageMultiplier = 93.7, levelRequirement = 70, manaCost = 5, statInterpolation = { }, },
		[21] = { 1, 25, damageMultiplier = 96, levelRequirement = 72, manaCost = 5, statInterpolation = { }, },
		[22] = { 1, 25, damageMultiplier = 98.3, levelRequirement = 74, manaCost = 5, statInterpolation = { }, },
		[23] = { 1, 25, damageMultiplier = 100.6, levelRequirement = 76, manaCost = 5, statInterpolation = { }, },
		[24] = { 1, 25, damageMultiplier = 102.9, levelRequirement = 78, manaCost = 5, statInterpolation = { }, },
		[25] = { 1, 25, damageMultiplier = 105.2, levelRequirement = 80, manaCost = 5, statInterpolation = { }, },
		[26] = { 1, 25, damageMultiplier = 107.5, levelRequirement = 82, manaCost = 5, statInterpolation = { }, },
		[27] = { 1, 25, damageMultiplier = 109.8, levelRequirement = 84, manaCost = 5, statInterpolation = { }, },
		[28] = { 1, 25, damageMultiplier = 112.1, levelRequirement = 86, manaCost = 5, statInterpolation = { }, },
		[29] = { 1, 25, damageMultiplier = 114.4, levelRequirement = 88, manaCost = 5, statInterpolation = { }, },
		[30] = { 1, 25, damageMultiplier = 116.7, levelRequirement = 90, manaCost = 5, statInterpolation = { }, },
	},
}
skills["HeraldOfAsh"] = {
	name = "Herald of Ash",
	color = 1,
	description = "Channel fire through your hands, adding fire to your physical damage. If you kill an enemy with an attack, other enemies near them will be ignited for the overkill damage.",
	skillTypes = { [2] = true, [5] = true, [15] = true, [16] = true, [29] = true, [11] = true, [40] = true, [20] = true, [33] = true, [27] = true, },
	castTime = 1,
	statMap = {
		["herald_of_ash_fire_damage_+%"] = {
			mod("FireDamage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["physical_damage_%_to_add_as_fire"] = {
			mod("PhysicalDamageGainAsFire", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" })
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 10),
	},
	qualityStats = {
		{ "herald_of_ash_fire_damage_+%", 0.75 },
	},
	stats = {
		"physical_damage_%_to_add_as_fire",
		"herald_of_ash_%_overkill_dealt_as_ignite",
		"is_area_damage",
	},
	levels = {
		[1] = { 15, 80, cooldown = 1, levelRequirement = 16, manaCost = 25, statInterpolation = { }, },
		[2] = { 15, 83, cooldown = 1, levelRequirement = 20, manaCost = 25, statInterpolation = { }, },
		[3] = { 15, 86, cooldown = 1, levelRequirement = 24, manaCost = 25, statInterpolation = { }, },
		[4] = { 15, 89, cooldown = 1, levelRequirement = 28, manaCost = 25, statInterpolation = { }, },
		[5] = { 15, 92, cooldown = 1, levelRequirement = 31, manaCost = 25, statInterpolation = { }, },
		[6] = { 15, 95, cooldown = 1, levelRequirement = 34, manaCost = 25, statInterpolation = { }, },
		[7] = { 15, 98, cooldown = 1, levelRequirement = 37, manaCost = 25, statInterpolation = { }, },
		[8] = { 15, 101, cooldown = 1, levelRequirement = 40, manaCost = 25, statInterpolation = { }, },
		[9] = { 15, 104, cooldown = 1, levelRequirement = 43, manaCost = 25, statInterpolation = { }, },
		[10] = { 15, 107, cooldown = 1, levelRequirement = 46, manaCost = 25, statInterpolation = { }, },
		[11] = { 15, 110, cooldown = 1, levelRequirement = 49, manaCost = 25, statInterpolation = { }, },
		[12] = { 15, 113, cooldown = 1, levelRequirement = 52, manaCost = 25, statInterpolation = { }, },
		[13] = { 15, 116, cooldown = 1, levelRequirement = 55, manaCost = 25, statInterpolation = { }, },
		[14] = { 15, 119, cooldown = 1, levelRequirement = 58, manaCost = 25, statInterpolation = { }, },
		[15] = { 15, 122, cooldown = 1, levelRequirement = 60, manaCost = 25, statInterpolation = { }, },
		[16] = { 15, 125, cooldown = 1, levelRequirement = 62, manaCost = 25, statInterpolation = { }, },
		[17] = { 15, 128, cooldown = 1, levelRequirement = 64, manaCost = 25, statInterpolation = { }, },
		[18] = { 15, 131, cooldown = 1, levelRequirement = 66, manaCost = 25, statInterpolation = { }, },
		[19] = { 15, 134, cooldown = 1, levelRequirement = 68, manaCost = 25, statInterpolation = { }, },
		[20] = { 15, 137, cooldown = 1, levelRequirement = 70, manaCost = 25, statInterpolation = { }, },
		[21] = { 15, 140, cooldown = 1, levelRequirement = 72, manaCost = 25, statInterpolation = { }, },
		[22] = { 15, 143, cooldown = 1, levelRequirement = 74, manaCost = 25, statInterpolation = { }, },
		[23] = { 15, 146, cooldown = 1, levelRequirement = 76, manaCost = 25, statInterpolation = { }, },
		[24] = { 15, 149, cooldown = 1, levelRequirement = 78, manaCost = 25, statInterpolation = { }, },
		[25] = { 15, 152, cooldown = 1, levelRequirement = 80, manaCost = 25, statInterpolation = { }, },
		[26] = { 15, 155, cooldown = 1, levelRequirement = 82, manaCost = 25, statInterpolation = { }, },
		[27] = { 15, 158, cooldown = 1, levelRequirement = 84, manaCost = 25, statInterpolation = { }, },
		[28] = { 15, 161, cooldown = 1, levelRequirement = 86, manaCost = 25, statInterpolation = { }, },
		[29] = { 15, 164, cooldown = 1, levelRequirement = 88, manaCost = 25, statInterpolation = { }, },
		[30] = { 15, 167, cooldown = 1, levelRequirement = 90, manaCost = 25, statInterpolation = { }, },
	},
}
skills["IceCrash"] = {
	name = "Ice Crash",
	color = 1,
	description = "Slam the ground with your main hand weapon, damaging enemies in an area around the impact in three stages. Enemies take slightly less damage on the second and third stage. Works with Swords, Maces, Axes, Staves and Unarmed. Cannot be used with Multistrike.",
	skillTypes = { [1] = true, [6] = true, [11] = true, [24] = true, [7] = true, [34] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "First Hit",
		},
		{
			name = "Second Hit",
		},
		{
			name = "Third Hit",
		},
	},
	statMap = {
		["ice_crash_second_hit_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
		["ice_crash_third_hit_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 3 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
		{ "cold_damage_+%", 1 },
	},
	stats = {
		"base_physical_damage_%_to_convert_to_cold",
		"active_skill_attack_speed_+%_final",
		"ice_crash_second_hit_damage_+%_final",
		"ice_crash_third_hit_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 50, -20, -10, -20, damageMultiplier = 70, levelRequirement = 28, manaCost = 8, statInterpolation = { }, },
		[2] = { 50, -20, -10, -20, damageMultiplier = 72, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[3] = { 50, -20, -10, -20, damageMultiplier = 74, levelRequirement = 34, manaCost = 8, statInterpolation = { }, },
		[4] = { 50, -20, -10, -20, damageMultiplier = 76, levelRequirement = 37, manaCost = 8, statInterpolation = { }, },
		[5] = { 50, -20, -10, -20, damageMultiplier = 78, levelRequirement = 40, manaCost = 8, statInterpolation = { }, },
		[6] = { 50, -20, -10, -20, damageMultiplier = 80, levelRequirement = 42, manaCost = 8, statInterpolation = { }, },
		[7] = { 50, -20, -10, -20, damageMultiplier = 82, levelRequirement = 44, manaCost = 8, statInterpolation = { }, },
		[8] = { 50, -20, -10, -20, damageMultiplier = 84, levelRequirement = 46, manaCost = 8, statInterpolation = { }, },
		[9] = { 50, -20, -10, -20, damageMultiplier = 86, levelRequirement = 48, manaCost = 8, statInterpolation = { }, },
		[10] = { 50, -20, -10, -20, damageMultiplier = 88, levelRequirement = 50, manaCost = 8, statInterpolation = { }, },
		[11] = { 50, -20, -10, -20, damageMultiplier = 90, levelRequirement = 52, manaCost = 8, statInterpolation = { }, },
		[12] = { 50, -20, -10, -20, damageMultiplier = 92, levelRequirement = 54, manaCost = 8, statInterpolation = { }, },
		[13] = { 50, -20, -10, -20, damageMultiplier = 94, levelRequirement = 56, manaCost = 8, statInterpolation = { }, },
		[14] = { 50, -20, -10, -20, damageMultiplier = 96, levelRequirement = 58, manaCost = 8, statInterpolation = { }, },
		[15] = { 50, -20, -10, -20, damageMultiplier = 98, levelRequirement = 60, manaCost = 8, statInterpolation = { }, },
		[16] = { 50, -20, -10, -20, damageMultiplier = 100, levelRequirement = 62, manaCost = 8, statInterpolation = { }, },
		[17] = { 50, -20, -10, -20, damageMultiplier = 102, levelRequirement = 64, manaCost = 8, statInterpolation = { }, },
		[18] = { 50, -20, -10, -20, damageMultiplier = 104, levelRequirement = 66, manaCost = 8, statInterpolation = { }, },
		[19] = { 50, -20, -10, -20, damageMultiplier = 106, levelRequirement = 68, manaCost = 8, statInterpolation = { }, },
		[20] = { 50, -20, -10, -20, damageMultiplier = 108, levelRequirement = 70, manaCost = 8, statInterpolation = { }, },
		[21] = { 50, -20, -10, -20, damageMultiplier = 110, levelRequirement = 72, manaCost = 8, statInterpolation = { }, },
		[22] = { 50, -20, -10, -20, damageMultiplier = 112, levelRequirement = 74, manaCost = 8, statInterpolation = { }, },
		[23] = { 50, -20, -10, -20, damageMultiplier = 114, levelRequirement = 76, manaCost = 8, statInterpolation = { }, },
		[24] = { 50, -20, -10, -20, damageMultiplier = 116, levelRequirement = 78, manaCost = 8, statInterpolation = { }, },
		[25] = { 50, -20, -10, -20, damageMultiplier = 118, levelRequirement = 80, manaCost = 8, statInterpolation = { }, },
		[26] = { 50, -20, -10, -20, damageMultiplier = 120, levelRequirement = 82, manaCost = 8, statInterpolation = { }, },
		[27] = { 50, -20, -10, -20, damageMultiplier = 122, levelRequirement = 84, manaCost = 8, statInterpolation = { }, },
		[28] = { 50, -20, -10, -20, damageMultiplier = 124, levelRequirement = 86, manaCost = 8, statInterpolation = { }, },
		[29] = { 50, -20, -10, -20, damageMultiplier = 116, levelRequirement = 88, manaCost = 8, statInterpolation = { }, },
		[30] = { 50, -20, -10, -20, damageMultiplier = 118, levelRequirement = 90, manaCost = 8, statInterpolation = { }, },
	},
}
skills["ImmortalCall"] = {
	name = "Immortal Call",
	color = 1,
	description = "Discharges Endurance Charges, making the character invulnerable to physical damage for a short time, proportional to how many endurance charges were expended.",
	skillTypes = { [2] = true, [5] = true, [12] = true, [18] = true, [36] = true, },
	castTime = 0.85,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_cast_speed_+%", 2 },
	},
	stats = {
		"base_skill_effect_duration",
		"buff_effect_duration_+%_per_endurance_charge",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 400, 100, cooldown = 3, levelRequirement = 34, manaCost = 21, statInterpolation = { }, },
		[2] = { 400, 103, cooldown = 3, levelRequirement = 36, manaCost = 22, statInterpolation = { }, },
		[3] = { 400, 106, cooldown = 3, levelRequirement = 38, manaCost = 23, statInterpolation = { }, },
		[4] = { 400, 109, cooldown = 3, levelRequirement = 40, manaCost = 24, statInterpolation = { }, },
		[5] = { 400, 112, cooldown = 3, levelRequirement = 42, manaCost = 25, statInterpolation = { }, },
		[6] = { 400, 115, cooldown = 3, levelRequirement = 44, manaCost = 25, statInterpolation = { }, },
		[7] = { 400, 118, cooldown = 3, levelRequirement = 46, manaCost = 26, statInterpolation = { }, },
		[8] = { 400, 121, cooldown = 3, levelRequirement = 48, manaCost = 27, statInterpolation = { }, },
		[9] = { 400, 124, cooldown = 3, levelRequirement = 50, manaCost = 28, statInterpolation = { }, },
		[10] = { 400, 127, cooldown = 3, levelRequirement = 52, manaCost = 29, statInterpolation = { }, },
		[11] = { 400, 130, cooldown = 3, levelRequirement = 54, manaCost = 30, statInterpolation = { }, },
		[12] = { 400, 133, cooldown = 3, levelRequirement = 56, manaCost = 31, statInterpolation = { }, },
		[13] = { 400, 136, cooldown = 3, levelRequirement = 58, manaCost = 31, statInterpolation = { }, },
		[14] = { 400, 139, cooldown = 3, levelRequirement = 60, manaCost = 32, statInterpolation = { }, },
		[15] = { 400, 142, cooldown = 3, levelRequirement = 62, manaCost = 33, statInterpolation = { }, },
		[16] = { 400, 145, cooldown = 3, levelRequirement = 64, manaCost = 34, statInterpolation = { }, },
		[17] = { 400, 148, cooldown = 3, levelRequirement = 66, manaCost = 35, statInterpolation = { }, },
		[18] = { 400, 151, cooldown = 3, levelRequirement = 68, manaCost = 36, statInterpolation = { }, },
		[19] = { 400, 154, cooldown = 3, levelRequirement = 69, manaCost = 36, statInterpolation = { }, },
		[20] = { 400, 157, cooldown = 3, levelRequirement = 70, manaCost = 36, statInterpolation = { }, },
		[21] = { 400, 160, cooldown = 3, levelRequirement = 72, manaCost = 37, statInterpolation = { }, },
		[22] = { 400, 163, cooldown = 3, levelRequirement = 74, manaCost = 38, statInterpolation = { }, },
		[23] = { 400, 166, cooldown = 3, levelRequirement = 76, manaCost = 39, statInterpolation = { }, },
		[24] = { 400, 169, cooldown = 3, levelRequirement = 78, manaCost = 40, statInterpolation = { }, },
		[25] = { 400, 172, cooldown = 3, levelRequirement = 80, manaCost = 41, statInterpolation = { }, },
		[26] = { 400, 175, cooldown = 3, levelRequirement = 82, manaCost = 41, statInterpolation = { }, },
		[27] = { 400, 178, cooldown = 3, levelRequirement = 84, manaCost = 42, statInterpolation = { }, },
		[28] = { 400, 181, cooldown = 3, levelRequirement = 86, manaCost = 43, statInterpolation = { }, },
		[29] = { 400, 184, cooldown = 3, levelRequirement = 88, manaCost = 44, statInterpolation = { }, },
		[30] = { 400, 187, cooldown = 3, levelRequirement = 90, manaCost = 45, statInterpolation = { }, },
	},
}
skills["VaalImmortalCall"] = {
	name = "Vaal Immortal Call",
	color = 1,
	description = "Discharges Endurance Charges, making the character unable to die for a short time, proportional to how many endurance charges were expended.",
	skillTypes = { [2] = true, [5] = true, [12] = true, [18] = true, [43] = true, },
	castTime = 0.85,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_cast_speed_+%", 2 },
	},
	stats = {
		"base_skill_effect_duration",
		"buff_effect_duration_+%_per_endurance_charge",
		"immortal_call_prevent_all_damage",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 400, 100, cooldown = 3, levelRequirement = 34, statInterpolation = { }, },
		[2] = { 400, 103, cooldown = 3, levelRequirement = 36, statInterpolation = { }, },
		[3] = { 400, 106, cooldown = 3, levelRequirement = 38, statInterpolation = { }, },
		[4] = { 400, 109, cooldown = 3, levelRequirement = 40, statInterpolation = { }, },
		[5] = { 400, 112, cooldown = 3, levelRequirement = 42, statInterpolation = { }, },
		[6] = { 400, 115, cooldown = 3, levelRequirement = 44, statInterpolation = { }, },
		[7] = { 400, 118, cooldown = 3, levelRequirement = 46, statInterpolation = { }, },
		[8] = { 400, 121, cooldown = 3, levelRequirement = 48, statInterpolation = { }, },
		[9] = { 400, 124, cooldown = 3, levelRequirement = 50, statInterpolation = { }, },
		[10] = { 400, 127, cooldown = 3, levelRequirement = 52, statInterpolation = { }, },
		[11] = { 400, 130, cooldown = 3, levelRequirement = 54, statInterpolation = { }, },
		[12] = { 400, 133, cooldown = 3, levelRequirement = 56, statInterpolation = { }, },
		[13] = { 400, 136, cooldown = 3, levelRequirement = 58, statInterpolation = { }, },
		[14] = { 400, 139, cooldown = 3, levelRequirement = 60, statInterpolation = { }, },
		[15] = { 400, 142, cooldown = 3, levelRequirement = 62, statInterpolation = { }, },
		[16] = { 400, 145, cooldown = 3, levelRequirement = 64, statInterpolation = { }, },
		[17] = { 400, 148, cooldown = 3, levelRequirement = 66, statInterpolation = { }, },
		[18] = { 400, 151, cooldown = 3, levelRequirement = 68, statInterpolation = { }, },
		[19] = { 400, 154, cooldown = 3, levelRequirement = 69, statInterpolation = { }, },
		[20] = { 400, 157, cooldown = 3, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 400, 160, cooldown = 3, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 400, 163, cooldown = 3, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 400, 166, cooldown = 3, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 400, 169, cooldown = 3, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 400, 172, cooldown = 3, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 400, 175, cooldown = 3, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 400, 178, cooldown = 3, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 400, 181, cooldown = 3, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 400, 184, cooldown = 3, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 400, 187, cooldown = 3, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["InfernalBlow"] = {
	name = "Infernal Blow",
	color = 1,
	description = "Hits the enemy, converting some of your physical damage to fire damage. If the enemy dies soon after being hit, they will explode, dealing fire damage to nearby enemies. The damage from this explosion cannot be reflected. Requires a Sword, Axe, Mace, Staff or Unarmed.",
	skillTypes = { [1] = true, [6] = true, [11] = true, [25] = true, [28] = true, [24] = true, [33] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
		skill("radius", 15),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"base_skill_effect_duration",
		"corpse_explosion_monster_life_%",
	},
	levels = {
		[1] = { 50, 500, 10, critChance = 5, damageMultiplier = 30, levelRequirement = 1, manaCost = 6, statInterpolation = { }, },
		[2] = { 50, 500, 10, critChance = 5, damageMultiplier = 31.6, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { 50, 500, 10, critChance = 5, damageMultiplier = 33.2, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[4] = { 50, 500, 10, critChance = 5, damageMultiplier = 34.8, levelRequirement = 7, manaCost = 6, statInterpolation = { }, },
		[5] = { 50, 500, 10, critChance = 5, damageMultiplier = 36.4, levelRequirement = 11, manaCost = 6, statInterpolation = { }, },
		[6] = { 50, 500, 10, critChance = 5, damageMultiplier = 38, levelRequirement = 16, manaCost = 6, statInterpolation = { }, },
		[7] = { 50, 500, 10, critChance = 5, damageMultiplier = 39.6, levelRequirement = 20, manaCost = 6, statInterpolation = { }, },
		[8] = { 50, 500, 10, critChance = 5, damageMultiplier = 41.2, levelRequirement = 24, manaCost = 6, statInterpolation = { }, },
		[9] = { 50, 500, 10, critChance = 5, damageMultiplier = 42.8, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[10] = { 50, 500, 10, critChance = 5, damageMultiplier = 44.4, levelRequirement = 32, manaCost = 6, statInterpolation = { }, },
		[11] = { 50, 500, 10, critChance = 5, damageMultiplier = 46, levelRequirement = 36, manaCost = 6, statInterpolation = { }, },
		[12] = { 50, 500, 10, critChance = 5, damageMultiplier = 47.6, levelRequirement = 40, manaCost = 6, statInterpolation = { }, },
		[13] = { 50, 500, 10, critChance = 5, damageMultiplier = 49.2, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[14] = { 50, 500, 10, critChance = 5, damageMultiplier = 50.8, levelRequirement = 48, manaCost = 6, statInterpolation = { }, },
		[15] = { 50, 500, 10, critChance = 5, damageMultiplier = 52.4, levelRequirement = 52, manaCost = 6, statInterpolation = { }, },
		[16] = { 50, 500, 10, critChance = 5, damageMultiplier = 54, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[17] = { 50, 500, 10, critChance = 5, damageMultiplier = 55.6, levelRequirement = 60, manaCost = 6, statInterpolation = { }, },
		[18] = { 50, 500, 10, critChance = 5, damageMultiplier = 57.2, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[19] = { 50, 500, 10, critChance = 5, damageMultiplier = 58.8, levelRequirement = 67, manaCost = 6, statInterpolation = { }, },
		[20] = { 50, 500, 10, critChance = 5, damageMultiplier = 60.4, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 50, 500, 10, critChance = 5, damageMultiplier = 62, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 50, 500, 10, critChance = 5, damageMultiplier = 63.6, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 50, 500, 10, critChance = 5, damageMultiplier = 65.2, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 50, 500, 10, critChance = 5, damageMultiplier = 66.8, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 50, 500, 10, critChance = 5, damageMultiplier = 68.4, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 50, 500, 10, critChance = 5, damageMultiplier = 70, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 50, 500, 10, critChance = 5, damageMultiplier = 71.6, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 50, 500, 10, critChance = 5, damageMultiplier = 73.2, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 50, 500, 10, critChance = 5, damageMultiplier = 74.8, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 50, 500, 10, critChance = 5, damageMultiplier = 76.4, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["LeapSlam"] = {
	name = "Leap Slam",
	color = 1,
	description = "Jump into the air, damaging enemies (and knocking back some) with your main hand where you land. Enemies you would land on are pushed out of the way. Requires an axe, mace, sword or staff.",
	skillTypes = { [1] = true, [6] = true, [7] = true, [11] = true, [24] = true, [38] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1.4,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 15),
	},
	qualityStats = {
		{ "base_global_chance_to_knockback_%", 0.5 },
	},
	stats = {
		"base_global_chance_to_knockback_%",
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { 20, manaCost = 15, levelRequirement = 10, statInterpolation = { }, },
		[2] = { 20, damageMultiplier = 1.2, levelRequirement = 13, manaCost = 15, statInterpolation = { }, },
		[3] = { 20, damageMultiplier = 2.4, levelRequirement = 17, manaCost = 15, statInterpolation = { }, },
		[4] = { 20, damageMultiplier = 3.6, levelRequirement = 21, manaCost = 15, statInterpolation = { }, },
		[5] = { 20, damageMultiplier = 4.8, levelRequirement = 25, manaCost = 15, statInterpolation = { }, },
		[6] = { 20, damageMultiplier = 6, levelRequirement = 29, manaCost = 15, statInterpolation = { }, },
		[7] = { 20, damageMultiplier = 7.2, levelRequirement = 33, manaCost = 15, statInterpolation = { }, },
		[8] = { 20, damageMultiplier = 8.4, levelRequirement = 36, manaCost = 15, statInterpolation = { }, },
		[9] = { 20, damageMultiplier = 9.6, levelRequirement = 39, manaCost = 15, statInterpolation = { }, },
		[10] = { 20, damageMultiplier = 10.8, levelRequirement = 42, manaCost = 15, statInterpolation = { }, },
		[11] = { 20, damageMultiplier = 12, levelRequirement = 45, manaCost = 15, statInterpolation = { }, },
		[12] = { 20, damageMultiplier = 13.2, levelRequirement = 48, manaCost = 15, statInterpolation = { }, },
		[13] = { 20, damageMultiplier = 14.4, levelRequirement = 51, manaCost = 15, statInterpolation = { }, },
		[14] = { 20, damageMultiplier = 15.6, levelRequirement = 54, manaCost = 15, statInterpolation = { }, },
		[15] = { 20, damageMultiplier = 16.8, levelRequirement = 57, manaCost = 15, statInterpolation = { }, },
		[16] = { 20, damageMultiplier = 18, levelRequirement = 60, manaCost = 15, statInterpolation = { }, },
		[17] = { 20, damageMultiplier = 19.2, levelRequirement = 63, manaCost = 15, statInterpolation = { }, },
		[18] = { 20, damageMultiplier = 20.4, levelRequirement = 66, manaCost = 15, statInterpolation = { }, },
		[19] = { 20, damageMultiplier = 21.6, levelRequirement = 68, manaCost = 15, statInterpolation = { }, },
		[20] = { 20, damageMultiplier = 22.8, levelRequirement = 70, manaCost = 15, statInterpolation = { }, },
		[21] = { 20, damageMultiplier = 24, levelRequirement = 72, manaCost = 15, statInterpolation = { }, },
		[22] = { 20, damageMultiplier = 25.2, levelRequirement = 74, manaCost = 15, statInterpolation = { }, },
		[23] = { 20, damageMultiplier = 26.4, levelRequirement = 76, manaCost = 15, statInterpolation = { }, },
		[24] = { 20, damageMultiplier = 27.6, levelRequirement = 78, manaCost = 15, statInterpolation = { }, },
		[25] = { 20, damageMultiplier = 28.8, levelRequirement = 80, manaCost = 15, statInterpolation = { }, },
		[26] = { 20, damageMultiplier = 30, levelRequirement = 82, manaCost = 15, statInterpolation = { }, },
		[27] = { 20, damageMultiplier = 31.2, levelRequirement = 84, manaCost = 15, statInterpolation = { }, },
		[28] = { 20, damageMultiplier = 32.4, levelRequirement = 86, manaCost = 15, statInterpolation = { }, },
		[29] = { 20, damageMultiplier = 33.6, levelRequirement = 88, manaCost = 15, statInterpolation = { }, },
		[30] = { 20, damageMultiplier = 34.8, levelRequirement = 90, manaCost = 15, statInterpolation = { }, },
	},
}
skills["MoltenShell"] = {
	name = "Molten Shell",
	color = 1,
	description = "Summons fiery elemental shields providing additional armour for a short duration. If cumulative physical damage prevented by your blocking or armour reaches a threshold, the shields explode outwards, dealing fire damage to surrounding enemies.",
	skillTypes = { [2] = true, [10] = true, [11] = true, [12] = true, [18] = true, [31] = true, [36] = true, [26] = true, [33] = true, },
	castTime = 0.5,
	statMap = {
		["base_resist_all_elements_%"] = {
			mod("ElementalResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["base_physical_damage_reduction_rating"] = {
			mod("Armour", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
	},
	qualityStats = {
		{ "base_chance_to_ignite_%", 1 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"fire_shield_damage_threshold",
		"base_physical_damage_reduction_rating",
		"base_resist_all_elements_%",
		"is_area_damage",
		"base_skill_effect_duration",
		"skill_override_pvp_scaling_time_ms",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 14, 20, 26, 17, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 4, manaCost = 8, statInterpolation = { }, },
		[2] = { 17, 26, 32, 20, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 6, manaCost = 9, statInterpolation = { }, },
		[3] = { 24, 35, 41, 26, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 9, manaCost = 9, statInterpolation = { }, },
		[4] = { 32, 47, 52, 33, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 12, manaCost = 10, statInterpolation = { }, },
		[5] = { 45, 68, 70, 44, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 16, manaCost = 11, statInterpolation = { }, },
		[6] = { 64, 96, 93, 58, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 20, manaCost = 12, statInterpolation = { }, },
		[7] = { 88, 132, 120, 75, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 24, manaCost = 13, statInterpolation = { }, },
		[8] = { 120, 180, 155, 97, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 28, manaCost = 14, statInterpolation = { }, },
		[9] = { 161, 241, 197, 123, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 32, manaCost = 16, statInterpolation = { }, },
		[10] = { 214, 321, 250, 156, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 36, manaCost = 17, statInterpolation = { }, },
		[11] = { 283, 425, 313, 196, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 40, manaCost = 19, statInterpolation = { }, },
		[12] = { 372, 558, 391, 245, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 44, manaCost = 20, statInterpolation = { }, },
		[13] = { 486, 729, 487, 304, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 48, manaCost = 22, statInterpolation = { }, },
		[14] = { 631, 947, 602, 376, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 52, manaCost = 23, statInterpolation = { }, },
		[15] = { 766, 1149, 705, 440, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 55, manaCost = 25, statInterpolation = { }, },
		[16] = { 928, 1392, 823, 515, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 58, manaCost = 25, statInterpolation = { }, },
		[17] = { 1122, 1683, 960, 600, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 61, manaCost = 26, statInterpolation = { }, },
		[18] = { 1354, 2031, 1118, 698, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 64, manaCost = 27, statInterpolation = { }, },
		[19] = { 1631, 2447, 1299, 812, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 67, manaCost = 27, statInterpolation = { }, },
		[20] = { 1962, 2943, 1508, 943, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 70, manaCost = 28, statInterpolation = { }, },
		[21] = { 2217, 3326, 1664, 1040, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 72, manaCost = 29, statInterpolation = { }, },
		[22] = { 2504, 3756, 1836, 1148, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 74, manaCost = 29, statInterpolation = { }, },
		[23] = { 2827, 4240, 2024, 1265, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 76, manaCost = 29, statInterpolation = { }, },
		[24] = { 3189, 4784, 2231, 1394, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 78, manaCost = 30, statInterpolation = { }, },
		[25] = { 3596, 5394, 2457, 1536, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 80, manaCost = 30, statInterpolation = { }, },
		[26] = { 4053, 6080, 2705, 1691, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 82, manaCost = 31, statInterpolation = { }, },
		[27] = { 4566, 6849, 2977, 1861, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 84, manaCost = 31, statInterpolation = { }, },
		[28] = { 5141, 7712, 3275, 2047, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 86, manaCost = 31, statInterpolation = { }, },
		[29] = { 5787, 8680, 3601, 2251, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 88, manaCost = 32, statInterpolation = { }, },
		[30] = { 6510, 9766, 3958, 2474, 0, 1, 10000, 1200, damageEffectiveness = 2, critChance = 5, levelRequirement = 90, manaCost = 32, statInterpolation = { }, },
	},
}
skills["VaalMoltenShell"] = {
	name = "Vaal Molten Shell",
	color = 1,
	description = "Summons fiery elemental shields providing additional armour for a short duration. Whenever you prevent any amount of physical damage from a hit, the shields cause a burst of flame, dealing fire damage to surrounding enemies.",
	skillTypes = { [2] = true, [10] = true, [11] = true, [12] = true, [18] = true, [31] = true, [26] = true, [43] = true, [33] = true, },
	castTime = 0.5,
	statMap = {
		["base_resist_all_elements_%"] = {
			mod("ElementalResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["base_physical_damage_reduction_rating"] = {
			mod("Armour", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_chance_to_ignite_%", 1 },
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_physical_damage_reduction_rating",
		"base_resist_all_elements_%",
		"is_area_damage",
		"base_skill_effect_duration",
		"skill_override_pvp_scaling_time_ms",
		"base_skill_show_average_damage_instead_of_dps",
		"molten_shell_explode_each_hit",
	},
	levels = {
		[1] = { 9, 14, 17, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 11, 17, 20, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 15, 23, 26, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 20, 30, 33, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 27, 41, 44, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 37, 56, 58, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 49, 74, 75, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 64, 96, 97, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 83, 124, 123, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 106, 159, 156, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 135, 202, 196, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 170, 256, 245, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 214, 321, 304, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 267, 401, 376, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 315, 472, 440, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 370, 556, 515, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 435, 652, 600, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 509, 764, 698, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 596, 893, 812, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 696, 1043, 943, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 771, 1156, 1040, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 854, 1280, 1148, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 945, 1417, 1265, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 1045, 1568, 1394, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 1155, 1733, 1536, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 1277, 1915, 1691, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 1410, 2115, 1861, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 1557, 2335, 2047, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 1718, 2577, 2251, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 1895, 2843, 2474, 0, 1, 5000, 1400, damageEffectiveness = 2, critChance = 5, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["MoltenStrike"] = {
	name = "Molten Strike",
	color = 1,
	description = "Attacks a target with physical and fire damage, causing balls of molten magma to launch forth from your weapon as you swing. These will explode, causing AoE attack damage to enemies where they land.",
	skillTypes = { [1] = true, [3] = true, [6] = true, [11] = true, [24] = true, [25] = true, [28] = true, [33] = true, [48] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Melee Hit",
			melee = true,
			projectile = false,
			area = false,
		},
		{
			name = "Magma Balls",
			melee = false,
			projectile = true,
			area = true,
		},
	},
	statMap = {
		["active_skill_damage_over_time_from_projectile_hits_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Dot, 0, { type = "SkillPart", skillPart = 2 })
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "fire_damage_+%", 1 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"number_of_additional_projectiles",
		"active_skill_projectile_damage_+%_final",
		"show_number_of_projectiles",
	},
	levels = {
		[1] = { 60, 2, -40, damageMultiplier = 20, levelRequirement = 1, manaCost = 6, statInterpolation = { }, },
		[2] = { 60, 2, -40, damageMultiplier = 21.4, levelRequirement = 2, manaCost = 6, statInterpolation = { }, },
		[3] = { 60, 2, -40, damageMultiplier = 22.8, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[4] = { 60, 2, -40, damageMultiplier = 24.2, levelRequirement = 7, manaCost = 6, statInterpolation = { }, },
		[5] = { 60, 2, -40, damageMultiplier = 25.6, levelRequirement = 11, manaCost = 6, statInterpolation = { }, },
		[6] = { 60, 2, -40, damageMultiplier = 27, levelRequirement = 16, manaCost = 6, statInterpolation = { }, },
		[7] = { 60, 2, -40, damageMultiplier = 28.4, levelRequirement = 20, manaCost = 6, statInterpolation = { }, },
		[8] = { 60, 2, -40, damageMultiplier = 29.8, levelRequirement = 24, manaCost = 6, statInterpolation = { }, },
		[9] = { 60, 2, -40, damageMultiplier = 31.2, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[10] = { 60, 2, -40, damageMultiplier = 32.6, levelRequirement = 32, manaCost = 6, statInterpolation = { }, },
		[11] = { 60, 2, -40, damageMultiplier = 34, levelRequirement = 36, manaCost = 6, statInterpolation = { }, },
		[12] = { 60, 2, -40, damageMultiplier = 35.4, levelRequirement = 40, manaCost = 6, statInterpolation = { }, },
		[13] = { 60, 2, -40, damageMultiplier = 36.8, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[14] = { 60, 2, -40, damageMultiplier = 38.2, levelRequirement = 48, manaCost = 6, statInterpolation = { }, },
		[15] = { 60, 2, -40, damageMultiplier = 39.6, levelRequirement = 52, manaCost = 6, statInterpolation = { }, },
		[16] = { 60, 2, -40, damageMultiplier = 41, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[17] = { 60, 2, -40, damageMultiplier = 42.4, levelRequirement = 60, manaCost = 6, statInterpolation = { }, },
		[18] = { 60, 2, -40, damageMultiplier = 43.8, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[19] = { 60, 2, -40, damageMultiplier = 45.2, levelRequirement = 67, manaCost = 6, statInterpolation = { }, },
		[20] = { 60, 2, -40, damageMultiplier = 46.6, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 60, 2, -40, damageMultiplier = 48, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 60, 2, -40, damageMultiplier = 49.4, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 60, 2, -40, damageMultiplier = 50.8, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 60, 2, -40, damageMultiplier = 52.2, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 60, 2, -40, damageMultiplier = 53.6, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 60, 2, -40, damageMultiplier = 55, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 60, 2, -40, damageMultiplier = 56.4, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 60, 2, -40, damageMultiplier = 57.8, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 60, 2, -40, damageMultiplier = 59.2, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 60, 2, -40, damageMultiplier = 60.6, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["Punishment"] = {
	name = "Punishment",
	color = 1,
	description = "Curses all targets in an area, causing them to grant a buff to anyone they hit with melee attacks. The buff grants more Melee Damage and increased Attack Speed.",
	skillTypes = { [2] = true, [11] = true, [12] = true, [17] = true, [18] = true, [19] = true, [26] = true, [32] = true, [36] = true, },
	castTime = 0.5,
	statMap = {
		["newpunishment_attack_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "CurseBuff" }),
		},
		["newpunishment_melee_damage_+%_final"] = {
			mod("PhysicalDamage", "MORE", nil, ModFlag.Melee, 0, { type = "GlobalEffect", effectType = "CurseBuff" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	qualityStats = {
		{ "newpunishment_attack_speed_+%", 0.25 },
	},
	stats = {
		"base_skill_effect_duration",
		"newpunishment_melee_damage_+%_final",
		"newpunishment_attack_speed_+%",
		"newpunishment_applied_buff_duration_ms",
		"base_skill_area_of_effect_+%",
	},
	levels = {
		[1] = { 9000, 25, 10, 4000, 0, manaCost = 24, levelRequirement = 24, statInterpolation = { }, },
		[2] = { 9100, 26, 10, 4000, 4, manaCost = 26, levelRequirement = 27, statInterpolation = { }, },
		[3] = { 9200, 26, 11, 4000, 8, manaCost = 27, levelRequirement = 30, statInterpolation = { }, },
		[4] = { 9300, 27, 11, 4000, 12, manaCost = 29, levelRequirement = 33, statInterpolation = { }, },
		[5] = { 9400, 27, 12, 4000, 16, manaCost = 30, levelRequirement = 36, statInterpolation = { }, },
		[6] = { 9500, 28, 12, 4000, 20, manaCost = 32, levelRequirement = 39, statInterpolation = { }, },
		[7] = { 9600, 28, 13, 4000, 24, manaCost = 34, levelRequirement = 42, statInterpolation = { }, },
		[8] = { 9700, 29, 13, 4000, 28, manaCost = 35, levelRequirement = 45, statInterpolation = { }, },
		[9] = { 9800, 29, 14, 4000, 32, manaCost = 37, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 9900, 30, 14, 4000, 36, manaCost = 38, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 10000, 30, 15, 4000, 40, manaCost = 39, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 10100, 31, 15, 4000, 44, manaCost = 40, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 10200, 31, 16, 4000, 48, manaCost = 42, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 10300, 32, 16, 4000, 52, manaCost = 43, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 10400, 32, 17, 4000, 56, manaCost = 44, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 10500, 33, 17, 4000, 60, manaCost = 45, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 10600, 33, 18, 4000, 64, manaCost = 46, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 10700, 34, 18, 4000, 68, manaCost = 47, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 10800, 34, 19, 4000, 72, manaCost = 48, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 10900, 35, 19, 4000, 76, manaCost = 50, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 11000, 35, 20, 4000, 80, manaCost = 51, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 11100, 36, 20, 4000, 84, manaCost = 52, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 11200, 36, 21, 4000, 88, manaCost = 53, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 11300, 37, 21, 4000, 92, manaCost = 54, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 11400, 37, 22, 4000, 96, manaCost = 56, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 11500, 38, 22, 4000, 100, manaCost = 57, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 11600, 38, 23, 4000, 104, manaCost = 58, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 11700, 39, 23, 4000, 108, manaCost = 59, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 11800, 39, 24, 4000, 112, manaCost = 60, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 11900, 40, 24, 4000, 116, manaCost = 61, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["FireResistAura"] = {
	name = "Purity of Fire",
	color = 1,
	description = "Casts an aura that grants fire resistance to you and your allies.",
	skillTypes = { [2] = true, [11] = true, [5] = true, [15] = true, [27] = true, [16] = true, [18] = true, [44] = true, [33] = true, },
	castTime = 1.2,
	statMap = {
		["base_fire_damage_resistance_%"] = {
			mod("FireResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["base_maximum_fire_damage_resistance_%"] = {
			mod("FireResistMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"base_fire_damage_resistance_%",
		"base_maximum_fire_damage_resistance_%",
		"base_skill_area_of_effect_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 22, 0, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 35, statInterpolation = { }, },
		[2] = { 23, 0, 3, cooldown = 1.2, levelRequirement = 27, manaCost = 35, statInterpolation = { }, },
		[3] = { 24, 0, 6, cooldown = 1.2, levelRequirement = 30, manaCost = 35, statInterpolation = { }, },
		[4] = { 25, 0, 9, cooldown = 1.2, levelRequirement = 33, manaCost = 35, statInterpolation = { }, },
		[5] = { 26, 1, 12, cooldown = 1.2, levelRequirement = 36, manaCost = 35, statInterpolation = { }, },
		[6] = { 27, 1, 15, cooldown = 1.2, levelRequirement = 39, manaCost = 35, statInterpolation = { }, },
		[7] = { 28, 1, 18, cooldown = 1.2, levelRequirement = 42, manaCost = 35, statInterpolation = { }, },
		[8] = { 29, 1, 21, cooldown = 1.2, levelRequirement = 45, manaCost = 35, statInterpolation = { }, },
		[9] = { 30, 1, 23, cooldown = 1.2, levelRequirement = 48, manaCost = 35, statInterpolation = { }, },
		[10] = { 31, 1, 25, cooldown = 1.2, levelRequirement = 50, manaCost = 35, statInterpolation = { }, },
		[11] = { 32, 2, 27, cooldown = 1.2, levelRequirement = 52, manaCost = 35, statInterpolation = { }, },
		[12] = { 33, 2, 29, cooldown = 1.2, levelRequirement = 54, manaCost = 35, statInterpolation = { }, },
		[13] = { 34, 2, 31, cooldown = 1.2, levelRequirement = 56, manaCost = 35, statInterpolation = { }, },
		[14] = { 35, 2, 33, cooldown = 1.2, levelRequirement = 58, manaCost = 35, statInterpolation = { }, },
		[15] = { 36, 2, 35, cooldown = 1.2, levelRequirement = 60, manaCost = 35, statInterpolation = { }, },
		[16] = { 37, 2, 36, cooldown = 1.2, levelRequirement = 62, manaCost = 35, statInterpolation = { }, },
		[17] = { 38, 3, 37, cooldown = 1.2, levelRequirement = 64, manaCost = 35, statInterpolation = { }, },
		[18] = { 39, 3, 38, cooldown = 1.2, levelRequirement = 66, manaCost = 35, statInterpolation = { }, },
		[19] = { 40, 3, 39, cooldown = 1.2, levelRequirement = 68, manaCost = 35, statInterpolation = { }, },
		[20] = { 41, 4, 40, cooldown = 1.2, levelRequirement = 70, manaCost = 35, statInterpolation = { }, },
		[21] = { 42, 4, 41, cooldown = 1.2, levelRequirement = 72, manaCost = 35, statInterpolation = { }, },
		[22] = { 43, 4, 42, cooldown = 1.2, levelRequirement = 74, manaCost = 35, statInterpolation = { }, },
		[23] = { 44, 5, 43, cooldown = 1.2, levelRequirement = 76, manaCost = 35, statInterpolation = { }, },
		[24] = { 45, 5, 44, cooldown = 1.2, levelRequirement = 78, manaCost = 35, statInterpolation = { }, },
		[25] = { 46, 5, 45, cooldown = 1.2, levelRequirement = 80, manaCost = 35, statInterpolation = { }, },
		[26] = { 47, 5, 46, cooldown = 1.2, levelRequirement = 82, manaCost = 35, statInterpolation = { }, },
		[27] = { 48, 5, 47, cooldown = 1.2, levelRequirement = 84, manaCost = 35, statInterpolation = { }, },
		[28] = { 49, 5, 48, cooldown = 1.2, levelRequirement = 86, manaCost = 35, statInterpolation = { }, },
		[29] = { 50, 5, 49, cooldown = 1.2, levelRequirement = 88, manaCost = 35, statInterpolation = { }, },
		[30] = { 51, 5, 50, cooldown = 1.2, levelRequirement = 90, manaCost = 35, statInterpolation = { }, },
	},
}
skills["RallyingCry"] = {
	name = "Rallying Cry",
	color = 1,
	description = "Performs a warcry, granting increased damage and mana regeneration to you and your allies if there are nearby enemies. The damage increase is scaled by surrounding enemies. Taunts all nearby enemies to attack the user. Shares a cooldown with other Warcry skills.",
	skillTypes = { [5] = true, [11] = true, [12] = true, },
	castTime = 0.25,
	statMap = {
		["damage_+%"] = {
			mod("Damage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["base_mana_regeneration_rate_per_minute"] = {
			mod("ManaRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("buffAllies", true),
	},
	qualityStats = {
		{ "skill_effect_duration_+%", 1.5 },
	},
	stats = {
		"inspiring_cry_damage_+%_per_one_hundred_nearby_enemies",
		"damage_+%",
		"base_mana_regeneration_rate_per_minute",
		"base_skill_effect_duration",
		"base_deal_no_damage",
		"is_warcry",
	},
	levels = {
		[1] = { 140, 10, 108, 8000, cooldown = 4, levelRequirement = 10, manaCost = 8, statInterpolation = { }, },
		[2] = { 142, 10, 144, 8000, cooldown = 4, levelRequirement = 13, manaCost = 10, statInterpolation = { }, },
		[3] = { 144, 11, 186, 8000, cooldown = 4, levelRequirement = 17, manaCost = 12, statInterpolation = { }, },
		[4] = { 146, 11, 228, 8000, cooldown = 4, levelRequirement = 21, manaCost = 13, statInterpolation = { }, },
		[5] = { 148, 11, 264, 8000, cooldown = 4, levelRequirement = 25, manaCost = 14, statInterpolation = { }, },
		[6] = { 150, 12, 306, 8000, cooldown = 4, levelRequirement = 29, manaCost = 15, statInterpolation = { }, },
		[7] = { 152, 12, 348, 8000, cooldown = 4, levelRequirement = 33, manaCost = 16, statInterpolation = { }, },
		[8] = { 154, 12, 390, 8000, cooldown = 4, levelRequirement = 36, manaCost = 17, statInterpolation = { }, },
		[9] = { 156, 13, 426, 8000, cooldown = 4, levelRequirement = 39, manaCost = 18, statInterpolation = { }, },
		[10] = { 158, 13, 468, 8000, cooldown = 4, levelRequirement = 42, manaCost = 20, statInterpolation = { }, },
		[11] = { 160, 13, 510, 8000, cooldown = 4, levelRequirement = 45, manaCost = 21, statInterpolation = { }, },
		[12] = { 162, 14, 552, 8000, cooldown = 4, levelRequirement = 48, manaCost = 22, statInterpolation = { }, },
		[13] = { 164, 14, 594, 8000, cooldown = 4, levelRequirement = 51, manaCost = 24, statInterpolation = { }, },
		[14] = { 166, 14, 636, 8000, cooldown = 4, levelRequirement = 54, manaCost = 25, statInterpolation = { }, },
		[15] = { 168, 15, 678, 8000, cooldown = 4, levelRequirement = 57, manaCost = 26, statInterpolation = { }, },
		[16] = { 170, 15, 720, 8000, cooldown = 4, levelRequirement = 60, manaCost = 26, statInterpolation = { }, },
		[17] = { 172, 15, 762, 8000, cooldown = 4, levelRequirement = 63, manaCost = 26, statInterpolation = { }, },
		[18] = { 174, 16, 804, 8000, cooldown = 4, levelRequirement = 66, manaCost = 26, statInterpolation = { }, },
		[19] = { 176, 16, 846, 8000, cooldown = 4, levelRequirement = 68, manaCost = 27, statInterpolation = { }, },
		[20] = { 178, 16, 888, 8000, cooldown = 4, levelRequirement = 70, manaCost = 27, statInterpolation = { }, },
		[21] = { 180, 17, 930, 8000, cooldown = 4, levelRequirement = 72, manaCost = 28, statInterpolation = { }, },
		[22] = { 182, 17, 972, 8000, cooldown = 4, levelRequirement = 74, manaCost = 28, statInterpolation = { }, },
		[23] = { 184, 17, 1014, 8000, cooldown = 4, levelRequirement = 76, manaCost = 29, statInterpolation = { }, },
		[24] = { 186, 18, 1062, 8000, cooldown = 4, levelRequirement = 78, manaCost = 29, statInterpolation = { }, },
		[25] = { 188, 18, 1104, 8000, cooldown = 4, levelRequirement = 80, manaCost = 30, statInterpolation = { }, },
		[26] = { 190, 18, 1146, 8000, cooldown = 4, levelRequirement = 82, manaCost = 30, statInterpolation = { }, },
		[27] = { 192, 19, 1188, 8000, cooldown = 4, levelRequirement = 84, manaCost = 30, statInterpolation = { }, },
		[28] = { 194, 19, 1230, 8000, cooldown = 4, levelRequirement = 86, manaCost = 30, statInterpolation = { }, },
		[29] = { 196, 19, 1278, 8000, cooldown = 4, levelRequirement = 88, manaCost = 31, statInterpolation = { }, },
		[30] = { 198, 20, 1320, 8000, cooldown = 4, levelRequirement = 90, manaCost = 31, statInterpolation = { }, },
	},
}
skills["Reckoning"] = {
	name = "Reckoning",
	color = 1,
	description = "Perform a swift counter-attack against enemies in a cone shape when you block with your shield.",
	skillTypes = { [1] = true, [7] = true, [13] = true, [24] = true, [11] = true, [47] = true, [57] = true, },
	weaponTypes = {
		["None"] = true,
		["Claw"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["One Handed Axe"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"melee_counterattack_trigger_on_block_%",
		"shield_counterattack_aoe_range",
		"attack_unusable_if_triggerable",
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
	},
	levels = {
		[1] = { 100, 35, damageMultiplier = -30, cooldown = 0.4, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 100, 35, damageMultiplier = -28, cooldown = 0.4, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 100, 35, damageMultiplier = -26, cooldown = 0.4, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 100, 35, damageMultiplier = -24, cooldown = 0.4, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 100, 35, damageMultiplier = -22, cooldown = 0.4, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 100, 35, damageMultiplier = -20, cooldown = 0.4, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 100, 35, damageMultiplier = -18, cooldown = 0.4, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 100, 35, damageMultiplier = -16, cooldown = 0.4, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 100, 35, damageMultiplier = -14, cooldown = 0.4, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 100, 35, damageMultiplier = -12, cooldown = 0.4, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 100, 35, damageMultiplier = -10, cooldown = 0.4, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 100, 35, damageMultiplier = -8, cooldown = 0.4, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 100, 35, damageMultiplier = -6, cooldown = 0.4, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 100, 35, damageMultiplier = -4, cooldown = 0.4, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 100, 35, damageMultiplier = -2, cooldown = 0.4, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 100, 35, cooldown = 0.4, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 100, 35, damageMultiplier = 2, cooldown = 0.4, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 100, 35, damageMultiplier = 4, cooldown = 0.4, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 100, 35, damageMultiplier = 6, cooldown = 0.4, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 100, 35, damageMultiplier = 8, cooldown = 0.4, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 100, 35, damageMultiplier = 10, cooldown = 0.4, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 100, 35, damageMultiplier = 12, cooldown = 0.4, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 100, 35, damageMultiplier = 14, cooldown = 0.4, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 100, 35, damageMultiplier = 16, cooldown = 0.4, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 100, 35, damageMultiplier = 18, cooldown = 0.4, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 100, 35, damageMultiplier = 20, cooldown = 0.4, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 100, 35, damageMultiplier = 22, cooldown = 0.4, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 100, 35, damageMultiplier = 24, cooldown = 0.4, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 100, 35, damageMultiplier = 26, cooldown = 0.4, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 100, 35, damageMultiplier = 28, cooldown = 0.4, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["RejuvenationTotem"] = {
	name = "Rejuvenation Totem",
	color = 1,
	description = "Summons a totem that has an aura which regenerates life for you and your nearby allies.",
	skillTypes = { [2] = true, [5] = true, [11] = true, [12] = true, [15] = true, [27] = true, [17] = true, [19] = true, [30] = true, [44] = true, },
	skillTotemId = 4,
	castTime = 0.6,
	statMap = {
		["base_life_regeneration_rate_per_minute"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		totem = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 10),
	},
	qualityStats = {
		{ "base_aura_area_of_effect_+%", 3 },
	},
	stats = {
		"is_totem",
		"base_totem_duration",
		"base_life_regeneration_rate_per_minute",
		"base_active_skill_totem_level",
		"base_totem_range",
		"base_skill_is_totemified",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 1, 8000, 381, 4, 10, manaCost = 13, levelRequirement = 4, statInterpolation = { }, },
		[2] = { 1, 8000, 521, 6, 10, manaCost = 14, levelRequirement = 6, statInterpolation = { }, },
		[3] = { 1, 8000, 742, 9, 10, manaCost = 15, levelRequirement = 9, statInterpolation = { }, },
		[4] = { 1, 8000, 960, 12, 10, manaCost = 16, levelRequirement = 12, statInterpolation = { }, },
		[5] = { 1, 8000, 1262, 16, 10, manaCost = 17, levelRequirement = 16, statInterpolation = { }, },
		[6] = { 1, 8000, 1578, 20, 10, manaCost = 18, levelRequirement = 20, statInterpolation = { }, },
		[7] = { 1, 8000, 1935, 24, 10, manaCost = 19, levelRequirement = 24, statInterpolation = { }, },
		[8] = { 1, 8000, 2362, 28, 10, manaCost = 20, levelRequirement = 28, statInterpolation = { }, },
		[9] = { 1, 8000, 2767, 32, 10, manaCost = 22, levelRequirement = 32, statInterpolation = { }, },
		[10] = { 1, 8000, 3222, 36, 10, manaCost = 24, levelRequirement = 36, statInterpolation = { }, },
		[11] = { 1, 8000, 3709, 40, 10, manaCost = 26, levelRequirement = 40, statInterpolation = { }, },
		[12] = { 1, 8000, 4368, 44, 10, manaCost = 27, levelRequirement = 44, statInterpolation = { }, },
		[13] = { 1, 8000, 4963, 48, 10, manaCost = 28, levelRequirement = 48, statInterpolation = { }, },
		[14] = { 1, 8000, 5560, 52, 10, manaCost = 29, levelRequirement = 52, statInterpolation = { }, },
		[15] = { 1, 8000, 6171, 55, 10, manaCost = 30, levelRequirement = 55, statInterpolation = { }, },
		[16] = { 1, 8000, 6839, 58, 10, manaCost = 30, levelRequirement = 58, statInterpolation = { }, },
		[17] = { 1, 8000, 7377, 61, 10, manaCost = 31, levelRequirement = 61, statInterpolation = { }, },
		[18] = { 1, 8000, 8136, 64, 10, manaCost = 31, levelRequirement = 64, statInterpolation = { }, },
		[19] = { 1, 8000, 8942, 67, 10, manaCost = 32, levelRequirement = 67, statInterpolation = { }, },
		[20] = { 1, 8000, 9732, 70, 10, manaCost = 32, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 1, 8000, 10117, 72, 10, manaCost = 33, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 1, 8000, 10622, 74, 10, manaCost = 34, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 1, 8000, 10926, 76, 10, manaCost = 34, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 1, 8000, 11472, 78, 10, manaCost = 35, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 1, 8000, 12040, 80, 10, manaCost = 36, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 1, 8000, 12362, 82, 10, manaCost = 37, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 1, 8000, 13046, 84, 10, manaCost = 38, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 1, 8000, 13677, 86, 10, manaCost = 38, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 1, 8000, 14473, 88, 10, manaCost = 39, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 1, 8000, 14619, 90, 10, manaCost = 40, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["SearingBond"] = {
	name = "Searing Bond",
	color = 1,
	description = "Summons a totem that casts a beam of fire at you and each other totem you control, dealing burning damage to enemies caught in the beam. Enemies near either end of a beam also suffer burning damage.",
	skillTypes = { [2] = true, [40] = true, [12] = true, [17] = true, [19] = true, [27] = true, [29] = true, [30] = true, [36] = true, [33] = true, },
	skillTotemId = 9,
	castTime = 1,
	baseFlags = {
		spell = true,
		totem = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "totem_life_+%", 1 },
	},
	stats = {
		"base_totem_duration",
		"base_totem_range",
		"base_active_skill_totem_level",
		"base_fire_damage_to_deal_per_minute",
		"number_of_additional_totems_allowed",
		"is_totem",
		"base_skill_is_totemified",
	},
	levels = {
		[1] = { 8000, 100, 12, 1415, 1, manaCost = 18, levelRequirement = 12, statInterpolation = { }, },
		[2] = { 8000, 100, 15, 1881, 1, manaCost = 19, levelRequirement = 15, statInterpolation = { }, },
		[3] = { 8000, 100, 19, 2689, 1, manaCost = 20, levelRequirement = 19, statInterpolation = { }, },
		[4] = { 8000, 100, 23, 3770, 1, manaCost = 21, levelRequirement = 23, statInterpolation = { }, },
		[5] = { 8000, 100, 27, 5207, 1, manaCost = 23, levelRequirement = 27, statInterpolation = { }, },
		[6] = { 8000, 100, 31, 7106, 1, manaCost = 25, levelRequirement = 31, statInterpolation = { }, },
		[7] = { 8000, 100, 35, 9604, 1, manaCost = 27, levelRequirement = 35, statInterpolation = { }, },
		[8] = { 8000, 100, 38, 11975, 1, manaCost = 29, levelRequirement = 38, statInterpolation = { }, },
		[9] = { 8000, 100, 41, 14873, 1, manaCost = 31, levelRequirement = 41, statInterpolation = { }, },
		[10] = { 8000, 100, 44, 18406, 1, manaCost = 33, levelRequirement = 44, statInterpolation = { }, },
		[11] = { 8000, 100, 47, 22709, 1, manaCost = 35, levelRequirement = 47, statInterpolation = { }, },
		[12] = { 8000, 100, 50, 27939, 1, manaCost = 37, levelRequirement = 50, statInterpolation = { }, },
		[13] = { 8000, 100, 53, 34287, 1, manaCost = 39, levelRequirement = 53, statInterpolation = { }, },
		[14] = { 8000, 100, 56, 41982, 1, manaCost = 40, levelRequirement = 56, statInterpolation = { }, },
		[15] = { 8000, 100, 59, 51296, 1, manaCost = 42, levelRequirement = 59, statInterpolation = { }, },
		[16] = { 8000, 100, 62, 62557, 1, manaCost = 44, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 8000, 100, 64, 71337, 1, manaCost = 46, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 8000, 100, 66, 81290, 1, manaCost = 48, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 8000, 100, 68, 92566, 1, manaCost = 50, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 8000, 100, 70, 105338, 1, manaCost = 51, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 8000, 100, 72, 119795, 1, manaCost = 53, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 8000, 100, 74, 136156, 1, manaCost = 53, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 8000, 100, 76, 154663, 1, manaCost = 54, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 8000, 100, 78, 175590, 1, manaCost = 56, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 8000, 100, 80, 199245, 1, manaCost = 58, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 8000, 100, 82, 225974, 1, manaCost = 59, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 8000, 100, 84, 256168, 1, manaCost = 59, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 8000, 100, 86, 290264, 1, manaCost = 61, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 8000, 100, 88, 328754, 1, manaCost = 62, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 8000, 100, 90, 372194, 1, manaCost = 64, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["NewShieldCharge"] = {
	name = "Shield Charge",
	color = 1,
	description = "Charges at a targeted location or enemy, pushing away enemies in your path and repeatedly dealing damage in a small area in front of you. You deal damage in a larger area when you reach the target. The further you travel, the more damage you deal, and the greater your chance of stunning enemies.",
	skillTypes = { [1] = true, [7] = true, [13] = true, [24] = true, [11] = true, [38] = true, },
	weaponTypes = {
		["None"] = true,
		["Claw"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["One Handed Axe"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "damage_+%", 1 },
	},
	stats = {
		"shield_charge_scaling_stun_threshold_reduction_+%_at_maximum_range",
		"base_movement_velocity_+%",
		"shield_charge_damage_+%_maximum",
		"ignores_proximity_shield",
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
	},
	levels = {
		[1] = { 50, 75, 200, damageMultiplier = -50, levelRequirement = 10, manaCost = 8, statInterpolation = { }, },
		[2] = { 50, 75, 200, damageMultiplier = -49.4, levelRequirement = 13, manaCost = 8, statInterpolation = { }, },
		[3] = { 50, 75, 200, damageMultiplier = -48.8, levelRequirement = 17, manaCost = 8, statInterpolation = { }, },
		[4] = { 50, 75, 200, damageMultiplier = -48.2, levelRequirement = 21, manaCost = 8, statInterpolation = { }, },
		[5] = { 50, 75, 200, damageMultiplier = -47.6, levelRequirement = 25, manaCost = 8, statInterpolation = { }, },
		[6] = { 50, 75, 200, damageMultiplier = -47, levelRequirement = 29, manaCost = 8, statInterpolation = { }, },
		[7] = { 50, 75, 200, damageMultiplier = -46.4, levelRequirement = 33, manaCost = 8, statInterpolation = { }, },
		[8] = { 50, 75, 200, damageMultiplier = -45.8, levelRequirement = 36, manaCost = 8, statInterpolation = { }, },
		[9] = { 50, 75, 200, damageMultiplier = -45.2, levelRequirement = 39, manaCost = 8, statInterpolation = { }, },
		[10] = { 50, 75, 200, damageMultiplier = -44.6, levelRequirement = 42, manaCost = 8, statInterpolation = { }, },
		[11] = { 50, 75, 200, damageMultiplier = -44, levelRequirement = 45, manaCost = 8, statInterpolation = { }, },
		[12] = { 50, 75, 200, damageMultiplier = -43.4, levelRequirement = 48, manaCost = 8, statInterpolation = { }, },
		[13] = { 50, 75, 200, damageMultiplier = -42.8, levelRequirement = 51, manaCost = 8, statInterpolation = { }, },
		[14] = { 50, 75, 200, damageMultiplier = -42.2, levelRequirement = 54, manaCost = 8, statInterpolation = { }, },
		[15] = { 50, 75, 200, damageMultiplier = -41.6, levelRequirement = 57, manaCost = 8, statInterpolation = { }, },
		[16] = { 50, 75, 200, damageMultiplier = -41, levelRequirement = 60, manaCost = 8, statInterpolation = { }, },
		[17] = { 50, 75, 200, damageMultiplier = -40.4, levelRequirement = 63, manaCost = 8, statInterpolation = { }, },
		[18] = { 50, 75, 200, damageMultiplier = -39.8, levelRequirement = 66, manaCost = 8, statInterpolation = { }, },
		[19] = { 50, 75, 200, damageMultiplier = -39.2, levelRequirement = 68, manaCost = 8, statInterpolation = { }, },
		[20] = { 50, 75, 200, damageMultiplier = -38.6, levelRequirement = 70, manaCost = 8, statInterpolation = { }, },
		[21] = { 50, 75, 200, damageMultiplier = -38, levelRequirement = 72, manaCost = 8, statInterpolation = { }, },
		[22] = { 50, 75, 200, damageMultiplier = -37.4, levelRequirement = 74, manaCost = 8, statInterpolation = { }, },
		[23] = { 50, 75, 200, damageMultiplier = -36.8, levelRequirement = 76, manaCost = 8, statInterpolation = { }, },
		[24] = { 50, 75, 200, damageMultiplier = -36.2, levelRequirement = 78, manaCost = 8, statInterpolation = { }, },
		[25] = { 50, 75, 200, damageMultiplier = -35.6, levelRequirement = 80, manaCost = 8, statInterpolation = { }, },
		[26] = { 50, 75, 200, damageMultiplier = -35, levelRequirement = 82, manaCost = 8, statInterpolation = { }, },
		[27] = { 50, 75, 200, damageMultiplier = -34.4, levelRequirement = 84, manaCost = 8, statInterpolation = { }, },
		[28] = { 50, 75, 200, damageMultiplier = -33.8, levelRequirement = 86, manaCost = 8, statInterpolation = { }, },
		[29] = { 50, 75, 200, damageMultiplier = -33.2, levelRequirement = 88, manaCost = 8, statInterpolation = { }, },
		[30] = { 50, 75, 200, damageMultiplier = -32.6, levelRequirement = 90, manaCost = 8, statInterpolation = { }, },
	},
}
skills["ShockwaveTotem"] = {
	name = "Shockwave Totem",
	color = 1,
	description = "Summons a totem that shakes the earth around it, knocking back and damaging nearby enemies",
	skillTypes = { [2] = true, [10] = true, [11] = true, [12] = true, [17] = true, [19] = true, [30] = true, [26] = true, },
	skillTotemId = 5,
	castTime = 0.6,
	baseFlags = {
		spell = true,
		totem = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
		{ "totem_life_+%", 1 },
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_active_skill_totem_level",
		"base_totem_duration",
		"base_totem_range",
		"base_global_chance_to_knockback_%",
		"is_totem",
		"is_area_damage",
		"base_skill_is_totemified",
	},
	levels = {
		[1] = { 23, 46, 28, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 28, manaCost = 24, statInterpolation = { }, },
		[2] = { 28, 51, 31, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 31, manaCost = 26, statInterpolation = { }, },
		[3] = { 33, 62, 34, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 34, manaCost = 28, statInterpolation = { }, },
		[4] = { 40, 74, 37, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 37, manaCost = 31, statInterpolation = { }, },
		[5] = { 47, 88, 40, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 40, manaCost = 33, statInterpolation = { }, },
		[6] = { 53, 98, 42, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 42, manaCost = 34, statInterpolation = { }, },
		[7] = { 59, 110, 44, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 44, manaCost = 36, statInterpolation = { }, },
		[8] = { 66, 123, 46, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 46, manaCost = 39, statInterpolation = { }, },
		[9] = { 74, 137, 48, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 48, manaCost = 43, statInterpolation = { }, },
		[10] = { 82, 153, 50, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 50, manaCost = 46, statInterpolation = { }, },
		[11] = { 92, 170, 52, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 52, manaCost = 49, statInterpolation = { }, },
		[12] = { 102, 189, 54, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 54, manaCost = 51, statInterpolation = { }, },
		[13] = { 113, 210, 56, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 56, manaCost = 53, statInterpolation = { }, },
		[14] = { 126, 233, 58, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 58, manaCost = 53, statInterpolation = { }, },
		[15] = { 139, 259, 60, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 60, manaCost = 55, statInterpolation = { }, },
		[16] = { 154, 287, 62, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 62, manaCost = 55, statInterpolation = { }, },
		[17] = { 171, 318, 64, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 64, manaCost = 57, statInterpolation = { }, },
		[18] = { 189, 351, 66, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 66, manaCost = 57, statInterpolation = { }, },
		[19] = { 209, 389, 68, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 68, manaCost = 58, statInterpolation = { }, },
		[20] = { 231, 429, 70, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 70, manaCost = 58, statInterpolation = { }, },
		[21] = { 255, 474, 72, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 72, manaCost = 59, statInterpolation = { }, },
		[22] = { 282, 524, 74, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 74, manaCost = 60, statInterpolation = { }, },
		[23] = { 311, 578, 76, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 76, manaCost = 61, statInterpolation = { }, },
		[24] = { 343, 637, 78, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 78, manaCost = 62, statInterpolation = { }, },
		[25] = { 378, 702, 80, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 80, manaCost = 62, statInterpolation = { }, },
		[26] = { 416, 773, 82, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 82, manaCost = 63, statInterpolation = { }, },
		[27] = { 458, 851, 84, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 84, manaCost = 64, statInterpolation = { }, },
		[28] = { 504, 936, 86, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 86, manaCost = 65, statInterpolation = { }, },
		[29] = { 555, 1030, 88, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 88, manaCost = 66, statInterpolation = { }, },
		[30] = { 610, 1132, 90, 8000, 100, 25, damageEffectiveness = 0.6, critChance = 5, levelRequirement = 90, manaCost = 66, statInterpolation = { }, },
	},
}
skills["StaticStrike"] = {
	name = "Static Strike",
	color = 1,
	description = "Strike your enemies with a melee weapon, building up static energy on you. This energy damages enemies around you when it expires. ",
	skillTypes = { [1] = true, [6] = true, [25] = true, [28] = true, [24] = true, [11] = true, [12] = true, [35] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Melee hit",
			area = false,
		},
		{
			name = "Explosion",
			area = true,
		},
	},
	statMap = {
		["static_strike_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, ModFlag.Attack, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 19),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"base_skill_effect_duration",
		"static_strike_explosion_damage_+%_final",
		"active_skill_base_radius_+",
	},
	levels = {
		[1] = { 60, 750, -40, 0, damageMultiplier = 10, levelRequirement = 12, manaCost = 6, statInterpolation = { }, },
		[2] = { 60, 750, -40, 0, damageMultiplier = 12.6, levelRequirement = 15, manaCost = 6, statInterpolation = { }, },
		[3] = { 60, 750, -40, 0, damageMultiplier = 15.2, levelRequirement = 19, manaCost = 6, statInterpolation = { }, },
		[4] = { 60, 750, -40, 0, damageMultiplier = 17.8, levelRequirement = 23, manaCost = 6, statInterpolation = { }, },
		[5] = { 60, 750, -40, 1, damageMultiplier = 20.4, levelRequirement = 27, manaCost = 6, statInterpolation = { }, },
		[6] = { 60, 750, -40, 1, damageMultiplier = 23, levelRequirement = 31, manaCost = 6, statInterpolation = { }, },
		[7] = { 60, 750, -40, 1, damageMultiplier = 25.6, levelRequirement = 35, manaCost = 6, statInterpolation = { }, },
		[8] = { 60, 750, -40, 1, damageMultiplier = 28.2, levelRequirement = 38, manaCost = 6, statInterpolation = { }, },
		[9] = { 60, 750, -40, 1, damageMultiplier = 30.8, levelRequirement = 41, manaCost = 6, statInterpolation = { }, },
		[10] = { 60, 750, -40, 2, damageMultiplier = 33.4, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[11] = { 60, 750, -40, 2, damageMultiplier = 36, levelRequirement = 47, manaCost = 6, statInterpolation = { }, },
		[12] = { 60, 750, -40, 2, damageMultiplier = 38.6, levelRequirement = 50, manaCost = 6, statInterpolation = { }, },
		[13] = { 60, 750, -40, 2, damageMultiplier = 41.2, levelRequirement = 53, manaCost = 6, statInterpolation = { }, },
		[14] = { 60, 750, -40, 2, damageMultiplier = 43.8, levelRequirement = 56, manaCost = 6, statInterpolation = { }, },
		[15] = { 60, 750, -40, 3, damageMultiplier = 46.4, levelRequirement = 59, manaCost = 6, statInterpolation = { }, },
		[16] = { 60, 750, -40, 3, damageMultiplier = 49, levelRequirement = 62, manaCost = 6, statInterpolation = { }, },
		[17] = { 60, 750, -40, 3, damageMultiplier = 51.6, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[18] = { 60, 750, -40, 3, damageMultiplier = 54.2, levelRequirement = 66, manaCost = 6, statInterpolation = { }, },
		[19] = { 60, 750, -40, 3, damageMultiplier = 56.8, levelRequirement = 68, manaCost = 6, statInterpolation = { }, },
		[20] = { 60, 750, -40, 4, damageMultiplier = 59.4, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 60, 750, -40, 4, damageMultiplier = 62, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 60, 750, -40, 4, damageMultiplier = 64.6, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 60, 750, -40, 4, damageMultiplier = 67.2, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 60, 750, -40, 4, damageMultiplier = 69.8, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 60, 750, -40, 5, damageMultiplier = 72.4, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 60, 750, -40, 5, damageMultiplier = 75, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 60, 750, -40, 5, damageMultiplier = 77.6, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 60, 750, -40, 5, damageMultiplier = 80.2, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 60, 750, -40, 5, damageMultiplier = 82.8, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 60, 750, -40, 6, damageMultiplier = 85.4, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["SummonFireGolem"] = {
	name = "Summon Flame Golem",
	color = 1,
	description = "Summons a Flame Golem that grants you increased Damage. The Flame Golem can use a fire spray, a wave of fire damage, and an explosive arcing projectile.",
	skillTypes = { [36] = true, [33] = true, [19] = true, [9] = true, [21] = true, [26] = true, [2] = true, [18] = true, [17] = true, [49] = true, [62] = true, },
	minionSkillTypes = { [10] = true, [11] = true, [3] = true, [2] = true, },
	castTime = 1,
	minionList = {
		"SummonedFlameGolem",
	},
	statMap = {
		["fire_golem_grants_damage_+%"] = {
			mod("Damage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveFireGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		{ "minion_maximum_life_+%", 1 },
		{ "minion_damage_+%", 1 },
	},
	stats = {
		"base_actor_scale_+%",
		"base_number_of_golems_allowed",
		"fire_golem_grants_damage_+%",
		"minion_maximum_life_+%",
		"display_minion_monster_type",
		"display_minion_monster_level",
	},
	levels = {
		[1] = { 0, 1, 15, 30, 7, 34, cooldown = 6, levelRequirement = 34, manaCost = 30, statInterpolation = { }, },
		[2] = { 1, 1, 15, 32, 7, 36, cooldown = 6, levelRequirement = 36, manaCost = 32, statInterpolation = { }, },
		[3] = { 1, 1, 16, 34, 7, 38, cooldown = 6, levelRequirement = 38, manaCost = 34, statInterpolation = { }, },
		[4] = { 2, 1, 16, 36, 7, 40, cooldown = 6, levelRequirement = 40, manaCost = 36, statInterpolation = { }, },
		[5] = { 2, 1, 16, 38, 7, 42, cooldown = 6, levelRequirement = 42, manaCost = 38, statInterpolation = { }, },
		[6] = { 3, 1, 16, 40, 7, 44, cooldown = 6, levelRequirement = 44, manaCost = 40, statInterpolation = { }, },
		[7] = { 3, 1, 17, 42, 7, 46, cooldown = 6, levelRequirement = 46, manaCost = 42, statInterpolation = { }, },
		[8] = { 4, 1, 17, 44, 7, 48, cooldown = 6, levelRequirement = 48, manaCost = 44, statInterpolation = { }, },
		[9] = { 4, 1, 17, 46, 7, 50, cooldown = 6, levelRequirement = 50, manaCost = 44, statInterpolation = { }, },
		[10] = { 5, 1, 17, 48, 7, 52, cooldown = 6, levelRequirement = 52, manaCost = 46, statInterpolation = { }, },
		[11] = { 5, 1, 18, 50, 7, 54, cooldown = 6, levelRequirement = 54, manaCost = 48, statInterpolation = { }, },
		[12] = { 6, 1, 18, 52, 7, 56, cooldown = 6, levelRequirement = 56, manaCost = 48, statInterpolation = { }, },
		[13] = { 6, 1, 18, 54, 7, 58, cooldown = 6, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[14] = { 7, 1, 18, 56, 7, 60, cooldown = 6, levelRequirement = 60, manaCost = 50, statInterpolation = { }, },
		[15] = { 7, 1, 19, 58, 7, 62, cooldown = 6, levelRequirement = 62, manaCost = 52, statInterpolation = { }, },
		[16] = { 8, 1, 19, 60, 7, 64, cooldown = 6, levelRequirement = 64, manaCost = 52, statInterpolation = { }, },
		[17] = { 8, 1, 19, 62, 7, 66, cooldown = 6, levelRequirement = 66, manaCost = 52, statInterpolation = { }, },
		[18] = { 9, 1, 19, 64, 7, 68, cooldown = 6, levelRequirement = 68, manaCost = 52, statInterpolation = { }, },
		[19] = { 9, 1, 20, 66, 7, 69, cooldown = 6, levelRequirement = 69, manaCost = 54, statInterpolation = { }, },
		[20] = { 10, 1, 20, 68, 7, 70, cooldown = 6, levelRequirement = 70, manaCost = 54, statInterpolation = { }, },
		[21] = { 10, 1, 20, 70, 7, 72, cooldown = 6, levelRequirement = 72, manaCost = 56, statInterpolation = { }, },
		[22] = { 11, 1, 20, 72, 7, 74, cooldown = 6, levelRequirement = 74, manaCost = 56, statInterpolation = { }, },
		[23] = { 11, 1, 21, 74, 7, 76, cooldown = 6, levelRequirement = 76, manaCost = 58, statInterpolation = { }, },
		[24] = { 12, 1, 21, 76, 7, 78, cooldown = 6, levelRequirement = 78, manaCost = 58, statInterpolation = { }, },
		[25] = { 12, 1, 21, 78, 7, 80, cooldown = 6, levelRequirement = 80, manaCost = 60, statInterpolation = { }, },
		[26] = { 13, 1, 21, 80, 7, 82, cooldown = 6, levelRequirement = 82, manaCost = 60, statInterpolation = { }, },
		[27] = { 13, 1, 22, 82, 7, 84, cooldown = 6, levelRequirement = 84, manaCost = 60, statInterpolation = { }, },
		[28] = { 14, 1, 22, 84, 7, 86, cooldown = 6, levelRequirement = 86, manaCost = 60, statInterpolation = { }, },
		[29] = { 14, 1, 22, 86, 7, 88, cooldown = 6, levelRequirement = 88, manaCost = 62, statInterpolation = { }, },
		[30] = { 15, 1, 22, 88, 7, 90, cooldown = 6, levelRequirement = 90, manaCost = 62, statInterpolation = { }, },
	},
}
skills["SummonRockGolem"] = {
	name = "Summon Stone Golem",
	color = 1,
	description = "Summons a Stone Golem that grants you life regeneration. In addition to its melee attack, the Stone Golem uses a rolling charge and a powerful slam that taunts enemies.",
	skillTypes = { [36] = true, [19] = true, [9] = true, [21] = true, [26] = true, [2] = true, [18] = true, [17] = true, [49] = true, [62] = true, },
	minionSkillTypes = { [1] = true, [24] = true, [25] = true, [38] = true, [11] = true, [28] = true, },
	castTime = 1,
	minionList = {
		"SummonedStoneGolem",
	},
	statMap = {
		["stone_golem_grants_base_life_regeneration_rate_per_minute"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		golem = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HavePhysicalGolem", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
		{ "minion_maximum_life_+%", 1 },
		{ "minion_damage_+%", 1 },
	},
	stats = {
		"base_actor_scale_+%",
		"base_number_of_golems_allowed",
		"minion_maximum_life_+%",
		"stone_golem_grants_base_life_regeneration_rate_per_minute",
		"display_minion_monster_type",
		"display_minion_monster_level",
	},
	levels = {
		[1] = { 0, 1, 30, 1980, 10, 34, cooldown = 6, levelRequirement = 34, manaCost = 30, statInterpolation = { }, },
		[2] = { 1, 1, 32, 2160, 10, 36, cooldown = 6, levelRequirement = 36, manaCost = 32, statInterpolation = { }, },
		[3] = { 1, 1, 34, 2340, 10, 38, cooldown = 6, levelRequirement = 38, manaCost = 34, statInterpolation = { }, },
		[4] = { 2, 1, 36, 2520, 10, 40, cooldown = 6, levelRequirement = 40, manaCost = 36, statInterpolation = { }, },
		[5] = { 2, 1, 38, 2700, 10, 42, cooldown = 6, levelRequirement = 42, manaCost = 38, statInterpolation = { }, },
		[6] = { 3, 1, 40, 2940, 10, 44, cooldown = 6, levelRequirement = 44, manaCost = 40, statInterpolation = { }, },
		[7] = { 3, 1, 42, 3120, 10, 46, cooldown = 6, levelRequirement = 46, manaCost = 42, statInterpolation = { }, },
		[8] = { 4, 1, 44, 3360, 10, 48, cooldown = 6, levelRequirement = 48, manaCost = 44, statInterpolation = { }, },
		[9] = { 4, 1, 46, 3600, 10, 50, cooldown = 6, levelRequirement = 50, manaCost = 44, statInterpolation = { }, },
		[10] = { 5, 1, 48, 3840, 10, 52, cooldown = 6, levelRequirement = 52, manaCost = 46, statInterpolation = { }, },
		[11] = { 5, 1, 50, 4080, 10, 54, cooldown = 6, levelRequirement = 54, manaCost = 48, statInterpolation = { }, },
		[12] = { 6, 1, 52, 4320, 10, 56, cooldown = 6, levelRequirement = 56, manaCost = 48, statInterpolation = { }, },
		[13] = { 6, 1, 54, 4560, 10, 58, cooldown = 6, levelRequirement = 58, manaCost = 50, statInterpolation = { }, },
		[14] = { 7, 1, 56, 4860, 10, 60, cooldown = 6, levelRequirement = 60, manaCost = 50, statInterpolation = { }, },
		[15] = { 7, 1, 58, 5100, 10, 62, cooldown = 6, levelRequirement = 62, manaCost = 52, statInterpolation = { }, },
		[16] = { 8, 1, 60, 5400, 10, 64, cooldown = 6, levelRequirement = 64, manaCost = 52, statInterpolation = { }, },
		[17] = { 8, 1, 62, 5700, 10, 66, cooldown = 6, levelRequirement = 66, manaCost = 52, statInterpolation = { }, },
		[18] = { 9, 1, 64, 6000, 10, 68, cooldown = 6, levelRequirement = 68, manaCost = 52, statInterpolation = { }, },
		[19] = { 9, 1, 66, 6180, 10, 69, cooldown = 6, levelRequirement = 69, manaCost = 54, statInterpolation = { }, },
		[20] = { 10, 1, 68, 6300, 10, 70, cooldown = 6, levelRequirement = 70, manaCost = 54, statInterpolation = { }, },
		[21] = { 10, 1, 70, 6600, 10, 72, cooldown = 6, levelRequirement = 72, manaCost = 56, statInterpolation = { }, },
		[22] = { 11, 1, 72, 6960, 10, 74, cooldown = 6, levelRequirement = 74, manaCost = 56, statInterpolation = { }, },
		[23] = { 11, 1, 74, 7260, 10, 76, cooldown = 6, levelRequirement = 76, manaCost = 58, statInterpolation = { }, },
		[24] = { 12, 1, 76, 7620, 10, 78, cooldown = 6, levelRequirement = 78, manaCost = 58, statInterpolation = { }, },
		[25] = { 12, 1, 78, 7980, 10, 80, cooldown = 6, levelRequirement = 80, manaCost = 60, statInterpolation = { }, },
		[26] = { 13, 1, 80, 8340, 10, 82, cooldown = 6, levelRequirement = 82, manaCost = 60, statInterpolation = { }, },
		[27] = { 13, 1, 82, 8700, 10, 84, cooldown = 6, levelRequirement = 84, manaCost = 60, statInterpolation = { }, },
		[28] = { 14, 1, 84, 9060, 10, 86, cooldown = 6, levelRequirement = 86, manaCost = 60, statInterpolation = { }, },
		[29] = { 14, 1, 86, 9420, 10, 88, cooldown = 6, levelRequirement = 88, manaCost = 62, statInterpolation = { }, },
		[30] = { 15, 1, 88, 9840, 10, 90, cooldown = 6, levelRequirement = 90, manaCost = 62, statInterpolation = { }, },
	},
}
skills["Sunder"] = {
	name = "Sunder",
	color = 1,
	description = "Slams the ground with your main hand weapon, creating a wave of broken ground that damages enemies in an area in front of you. Enemies hit by the wave will release a circular shockwave, dealing damage to other enemies around them. Requires a Mace, Axe, or Staff.",
	skillTypes = { [1] = true, [6] = true, [7] = true, [11] = true, [28] = true, [24] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Two Handed Axe"] = true,
		["Staff"] = true,
	},
	castTime = 1,
	parts = {
		{
			name = "Primary wave",
		},
		{
			name = "Shockwaves",
		},
	},
	statMap = {
		["shockwave_slam_explosion_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"shockwave_slam_explosion_damage_+%_final",
		"active_skill_attack_speed_+%_final",
		"active_skill_base_radius_+",
		"is_area_damage",
	},
	levels = {
		[1] = { -60, -15, 0, damageMultiplier = 40, levelRequirement = 12, manaCost = 8, statInterpolation = { }, },
		[2] = { -60, -15, 0, damageMultiplier = 42.2, levelRequirement = 15, manaCost = 8, statInterpolation = { }, },
		[3] = { -60, -15, 1, damageMultiplier = 44.4, levelRequirement = 19, manaCost = 8, statInterpolation = { }, },
		[4] = { -60, -15, 1, damageMultiplier = 46.6, levelRequirement = 23, manaCost = 8, statInterpolation = { }, },
		[5] = { -60, -15, 1, damageMultiplier = 48.8, levelRequirement = 27, manaCost = 8, statInterpolation = { }, },
		[6] = { -60, -15, 2, damageMultiplier = 51, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[7] = { -60, -15, 2, damageMultiplier = 53.2, levelRequirement = 35, manaCost = 8, statInterpolation = { }, },
		[8] = { -60, -15, 2, damageMultiplier = 55.4, levelRequirement = 38, manaCost = 8, statInterpolation = { }, },
		[9] = { -60, -15, 3, damageMultiplier = 57.6, levelRequirement = 41, manaCost = 8, statInterpolation = { }, },
		[10] = { -60, -15, 3, damageMultiplier = 59.8, levelRequirement = 44, manaCost = 8, statInterpolation = { }, },
		[11] = { -60, -15, 3, damageMultiplier = 62, levelRequirement = 47, manaCost = 8, statInterpolation = { }, },
		[12] = { -60, -15, 4, damageMultiplier = 64.2, levelRequirement = 50, manaCost = 8, statInterpolation = { }, },
		[13] = { -60, -15, 4, damageMultiplier = 66.4, levelRequirement = 53, manaCost = 8, statInterpolation = { }, },
		[14] = { -60, -15, 4, damageMultiplier = 68.6, levelRequirement = 56, manaCost = 8, statInterpolation = { }, },
		[15] = { -60, -15, 5, damageMultiplier = 70.8, levelRequirement = 59, manaCost = 8, statInterpolation = { }, },
		[16] = { -60, -15, 5, damageMultiplier = 73, levelRequirement = 62, manaCost = 8, statInterpolation = { }, },
		[17] = { -60, -15, 5, damageMultiplier = 75.2, levelRequirement = 64, manaCost = 8, statInterpolation = { }, },
		[18] = { -60, -15, 6, damageMultiplier = 77.4, levelRequirement = 66, manaCost = 8, statInterpolation = { }, },
		[19] = { -60, -15, 6, damageMultiplier = 79.6, levelRequirement = 68, manaCost = 8, statInterpolation = { }, },
		[20] = { -60, -15, 6, damageMultiplier = 81.8, levelRequirement = 70, manaCost = 8, statInterpolation = { }, },
		[21] = { -60, -15, 7, damageMultiplier = 84, levelRequirement = 72, manaCost = 8, statInterpolation = { }, },
		[22] = { -60, -15, 7, damageMultiplier = 86.2, levelRequirement = 74, manaCost = 8, statInterpolation = { }, },
		[23] = { -60, -15, 7, damageMultiplier = 88.4, levelRequirement = 76, manaCost = 8, statInterpolation = { }, },
		[24] = { -60, -15, 8, damageMultiplier = 90.6, levelRequirement = 78, manaCost = 8, statInterpolation = { }, },
		[25] = { -60, -15, 8, damageMultiplier = 92.8, levelRequirement = 80, manaCost = 8, statInterpolation = { }, },
		[26] = { -60, -15, 8, damageMultiplier = 95, levelRequirement = 82, manaCost = 8, statInterpolation = { }, },
		[27] = { -60, -15, 9, damageMultiplier = 97.2, levelRequirement = 84, manaCost = 8, statInterpolation = { }, },
		[28] = { -60, -15, 9, damageMultiplier = 99.4, levelRequirement = 86, manaCost = 8, statInterpolation = { }, },
		[29] = { -60, -15, 9, damageMultiplier = 101.6, levelRequirement = 88, manaCost = 8, statInterpolation = { }, },
		[30] = { -60, -15, 10, damageMultiplier = 103.8, levelRequirement = 90, manaCost = 8, statInterpolation = { }, },
	},
}
skills["Sweep"] = {
	name = "Sweep",
	color = 1,
	description = "Swings a two handed melee weapon in a circle, knocking back some monsters around the character.",
	skillTypes = { [1] = true, [11] = true, [28] = true, [24] = true, },
	weaponTypes = {
		["Two Handed Mace"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
	},
	castTime = 1.15,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("radius", 26),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 0.5 },
	},
	stats = {
		"base_global_chance_to_knockback_%",
		"active_skill_attack_speed_+%_final",
		"active_skill_base_radius_+",
		"is_area_damage",
	},
	levels = {
		[1] = { 30, -10, 0, manaCost = 8, levelRequirement = 12, statInterpolation = { }, },
		[2] = { 30, -10, 0, damageMultiplier = 2, levelRequirement = 15, manaCost = 8, statInterpolation = { }, },
		[3] = { 31, -10, 0, damageMultiplier = 4, levelRequirement = 19, manaCost = 8, statInterpolation = { }, },
		[4] = { 31, -10, 0, damageMultiplier = 6, levelRequirement = 23, manaCost = 8, statInterpolation = { }, },
		[5] = { 32, -10, 1, damageMultiplier = 8, levelRequirement = 27, manaCost = 8, statInterpolation = { }, },
		[6] = { 32, -10, 1, damageMultiplier = 10, levelRequirement = 31, manaCost = 8, statInterpolation = { }, },
		[7] = { 33, -10, 1, damageMultiplier = 12, levelRequirement = 35, manaCost = 8, statInterpolation = { }, },
		[8] = { 33, -10, 1, damageMultiplier = 14, levelRequirement = 38, manaCost = 8, statInterpolation = { }, },
		[9] = { 34, -10, 1, damageMultiplier = 16, levelRequirement = 41, manaCost = 8, statInterpolation = { }, },
		[10] = { 34, -10, 2, damageMultiplier = 18, levelRequirement = 44, manaCost = 8, statInterpolation = { }, },
		[11] = { 35, -10, 2, damageMultiplier = 20, levelRequirement = 47, manaCost = 8, statInterpolation = { }, },
		[12] = { 35, -10, 2, damageMultiplier = 22, levelRequirement = 50, manaCost = 8, statInterpolation = { }, },
		[13] = { 36, -10, 2, damageMultiplier = 24, levelRequirement = 53, manaCost = 8, statInterpolation = { }, },
		[14] = { 36, -10, 2, damageMultiplier = 26, levelRequirement = 56, manaCost = 8, statInterpolation = { }, },
		[15] = { 37, -10, 3, damageMultiplier = 28, levelRequirement = 59, manaCost = 8, statInterpolation = { }, },
		[16] = { 37, -10, 3, damageMultiplier = 30, levelRequirement = 62, manaCost = 8, statInterpolation = { }, },
		[17] = { 38, -10, 3, damageMultiplier = 32, levelRequirement = 64, manaCost = 8, statInterpolation = { }, },
		[18] = { 38, -10, 3, damageMultiplier = 34, levelRequirement = 66, manaCost = 8, statInterpolation = { }, },
		[19] = { 39, -10, 3, damageMultiplier = 36, levelRequirement = 68, manaCost = 8, statInterpolation = { }, },
		[20] = { 39, -10, 4, damageMultiplier = 38, levelRequirement = 70, manaCost = 8, statInterpolation = { }, },
		[21] = { 40, -10, 4, damageMultiplier = 40, levelRequirement = 72, manaCost = 8, statInterpolation = { }, },
		[22] = { 40, -10, 4, damageMultiplier = 42, levelRequirement = 74, manaCost = 8, statInterpolation = { }, },
		[23] = { 41, -10, 4, damageMultiplier = 44, levelRequirement = 76, manaCost = 8, statInterpolation = { }, },
		[24] = { 41, -10, 4, damageMultiplier = 46, levelRequirement = 78, manaCost = 8, statInterpolation = { }, },
		[25] = { 42, -10, 5, damageMultiplier = 48, levelRequirement = 80, manaCost = 8, statInterpolation = { }, },
		[26] = { 42, -10, 5, damageMultiplier = 50, levelRequirement = 82, manaCost = 8, statInterpolation = { }, },
		[27] = { 43, -10, 5, damageMultiplier = 52, levelRequirement = 84, manaCost = 8, statInterpolation = { }, },
		[28] = { 43, -10, 5, damageMultiplier = 54, levelRequirement = 86, manaCost = 8, statInterpolation = { }, },
		[29] = { 44, -10, 5, damageMultiplier = 56, levelRequirement = 88, manaCost = 8, statInterpolation = { }, },
		[30] = { 44, -10, 6, damageMultiplier = 58, levelRequirement = 90, manaCost = 8, statInterpolation = { }, },
	},
}
skills["Vengeance"] = {
	name = "Vengeance",
	color = 1,
	description = "Chance to perform a swift counter-attack against all enemies around you when you are hit. Weapon range increases the area of this attack. Requires a Melee Weapon.",
	skillTypes = { [1] = true, [11] = true, [24] = true, [47] = true, [6] = true, [57] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "melee_counterattack_trigger_on_hit_%", 0.5 },
	},
	stats = {
		"melee_counterattack_trigger_on_hit_%",
		"attack_unusable_if_triggerable",
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
	},
	levels = {
		[1] = { 30, damageMultiplier = -25, cooldown = 1.2, levelRequirement = 24, statInterpolation = { }, },
		[2] = { 30, damageMultiplier = -23, cooldown = 1.2, levelRequirement = 27, statInterpolation = { }, },
		[3] = { 30, damageMultiplier = -21, cooldown = 1.2, levelRequirement = 30, statInterpolation = { }, },
		[4] = { 30, damageMultiplier = -19, cooldown = 1.2, levelRequirement = 33, statInterpolation = { }, },
		[5] = { 30, damageMultiplier = -17, cooldown = 1.2, levelRequirement = 36, statInterpolation = { }, },
		[6] = { 30, damageMultiplier = -15, cooldown = 1.2, levelRequirement = 39, statInterpolation = { }, },
		[7] = { 30, damageMultiplier = -13, cooldown = 1.2, levelRequirement = 42, statInterpolation = { }, },
		[8] = { 30, damageMultiplier = -11, cooldown = 1.2, levelRequirement = 45, statInterpolation = { }, },
		[9] = { 30, damageMultiplier = -9, cooldown = 1.2, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 30, damageMultiplier = -7, cooldown = 1.2, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 30, damageMultiplier = -5, cooldown = 1.2, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 30, damageMultiplier = -3, cooldown = 1.2, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 30, damageMultiplier = -1, cooldown = 1.2, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 30, damageMultiplier = 1, cooldown = 1.2, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 30, damageMultiplier = 3, cooldown = 1.2, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 30, damageMultiplier = 5, cooldown = 1.2, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 30, damageMultiplier = 7, cooldown = 1.2, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 30, damageMultiplier = 9, cooldown = 1.2, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 30, damageMultiplier = 11, cooldown = 1.2, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 30, damageMultiplier = 13, cooldown = 1.2, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 30, damageMultiplier = 15, cooldown = 1.2, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 30, damageMultiplier = 17, cooldown = 1.2, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 30, damageMultiplier = 19, cooldown = 1.2, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 30, damageMultiplier = 21, cooldown = 1.2, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 30, damageMultiplier = 23, cooldown = 1.2, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 30, damageMultiplier = 25, cooldown = 1.2, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 30, damageMultiplier = 27, cooldown = 1.2, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 30, damageMultiplier = 29, cooldown = 1.2, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 30, damageMultiplier = 31, cooldown = 1.2, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 30, damageMultiplier = 33, cooldown = 1.2, levelRequirement = 90, statInterpolation = { }, },
	},
}
skills["VigilantStrike"] = {
	name = "Vigilant Strike",
	color = 1,
	description = "Attacks the enemy with a powerful melee strike. You gain the Fortify buff, granting damage reduction. The cooldown can be bypassed by expending an Endurance Charge. Requires a Melee Weapon.",
	skillTypes = { [1] = true, [5] = true, [24] = true, [6] = true, [28] = true, [25] = true, [53] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
		{ "fortify_duration_+%", 1 },
	},
	stats = {
		"fortify_duration_+%",
		"global_always_hit",
	},
	levels = {
		[1] = { 75, cooldown = 4, damageMultiplier = 65, levelRequirement = 4, manaCost = 6, statInterpolation = { }, },
		[2] = { 80, cooldown = 4, damageMultiplier = 67, levelRequirement = 6, manaCost = 6, statInterpolation = { }, },
		[3] = { 85, cooldown = 4, damageMultiplier = 69, levelRequirement = 9, manaCost = 6, statInterpolation = { }, },
		[4] = { 90, cooldown = 4, damageMultiplier = 71, levelRequirement = 12, manaCost = 6, statInterpolation = { }, },
		[5] = { 95, cooldown = 4, damageMultiplier = 73, levelRequirement = 16, manaCost = 6, statInterpolation = { }, },
		[6] = { 100, cooldown = 4, damageMultiplier = 75, levelRequirement = 20, manaCost = 6, statInterpolation = { }, },
		[7] = { 105, cooldown = 4, damageMultiplier = 77, levelRequirement = 24, manaCost = 6, statInterpolation = { }, },
		[8] = { 110, cooldown = 4, damageMultiplier = 79, levelRequirement = 28, manaCost = 6, statInterpolation = { }, },
		[9] = { 115, cooldown = 4, damageMultiplier = 81, levelRequirement = 32, manaCost = 6, statInterpolation = { }, },
		[10] = { 120, cooldown = 4, damageMultiplier = 83, levelRequirement = 36, manaCost = 6, statInterpolation = { }, },
		[11] = { 125, cooldown = 4, damageMultiplier = 85, levelRequirement = 40, manaCost = 6, statInterpolation = { }, },
		[12] = { 130, cooldown = 4, damageMultiplier = 87, levelRequirement = 44, manaCost = 6, statInterpolation = { }, },
		[13] = { 135, cooldown = 4, damageMultiplier = 89, levelRequirement = 48, manaCost = 6, statInterpolation = { }, },
		[14] = { 140, cooldown = 4, damageMultiplier = 91, levelRequirement = 52, manaCost = 6, statInterpolation = { }, },
		[15] = { 145, cooldown = 4, damageMultiplier = 93, levelRequirement = 55, manaCost = 6, statInterpolation = { }, },
		[16] = { 150, cooldown = 4, damageMultiplier = 95, levelRequirement = 58, manaCost = 6, statInterpolation = { }, },
		[17] = { 155, cooldown = 4, damageMultiplier = 97, levelRequirement = 61, manaCost = 6, statInterpolation = { }, },
		[18] = { 160, cooldown = 4, damageMultiplier = 99, levelRequirement = 64, manaCost = 6, statInterpolation = { }, },
		[19] = { 165, cooldown = 4, damageMultiplier = 101, levelRequirement = 67, manaCost = 6, statInterpolation = { }, },
		[20] = { 170, cooldown = 4, damageMultiplier = 103, levelRequirement = 70, manaCost = 6, statInterpolation = { }, },
		[21] = { 175, cooldown = 4, damageMultiplier = 105, levelRequirement = 72, manaCost = 6, statInterpolation = { }, },
		[22] = { 180, cooldown = 4, damageMultiplier = 107, levelRequirement = 74, manaCost = 6, statInterpolation = { }, },
		[23] = { 185, cooldown = 4, damageMultiplier = 109, levelRequirement = 76, manaCost = 6, statInterpolation = { }, },
		[24] = { 190, cooldown = 4, damageMultiplier = 111, levelRequirement = 78, manaCost = 6, statInterpolation = { }, },
		[25] = { 195, cooldown = 4, damageMultiplier = 113, levelRequirement = 80, manaCost = 6, statInterpolation = { }, },
		[26] = { 200, cooldown = 4, damageMultiplier = 115, levelRequirement = 82, manaCost = 6, statInterpolation = { }, },
		[27] = { 205, cooldown = 4, damageMultiplier = 117, levelRequirement = 84, manaCost = 6, statInterpolation = { }, },
		[28] = { 210, cooldown = 4, damageMultiplier = 119, levelRequirement = 86, manaCost = 6, statInterpolation = { }, },
		[29] = { 215, cooldown = 4, damageMultiplier = 121, levelRequirement = 88, manaCost = 6, statInterpolation = { }, },
		[30] = { 220, cooldown = 4, damageMultiplier = 123, levelRequirement = 90, manaCost = 6, statInterpolation = { }, },
	},
}
skills["Vitality"] = {
	name = "Vitality",
	color = 1,
	description = "Casts an aura that grants life regeneration to you and your allies.",
	skillTypes = { [2] = true, [11] = true, [5] = true, [15] = true, [27] = true, [16] = true, [18] = true, [44] = true, },
	castTime = 1.2,
	statMap = {
		["life_regeneration_rate_per_minute_%"] = {
			mod("LifeRegenPercent", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Aura" }),
			div = 60,
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 36),
	},
	qualityStats = {
		{ "base_skill_area_of_effect_+%", 1 },
	},
	stats = {
		"life_regeneration_rate_per_minute_%",
		"base_skill_area_of_effect_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 42, 0, cooldown = 1.2, levelRequirement = 24, manaCost = 35, statInterpolation = { }, },
		[2] = { 45, 3, cooldown = 1.2, levelRequirement = 27, manaCost = 35, statInterpolation = { }, },
		[3] = { 48, 6, cooldown = 1.2, levelRequirement = 30, manaCost = 35, statInterpolation = { }, },
		[4] = { 51, 9, cooldown = 1.2, levelRequirement = 33, manaCost = 35, statInterpolation = { }, },
		[5] = { 54, 12, cooldown = 1.2, levelRequirement = 36, manaCost = 35, statInterpolation = { }, },
		[6] = { 57, 15, cooldown = 1.2, levelRequirement = 39, manaCost = 35, statInterpolation = { }, },
		[7] = { 60, 18, cooldown = 1.2, levelRequirement = 42, manaCost = 35, statInterpolation = { }, },
		[8] = { 63, 21, cooldown = 1.2, levelRequirement = 45, manaCost = 35, statInterpolation = { }, },
		[9] = { 66, 23, cooldown = 1.2, levelRequirement = 48, manaCost = 35, statInterpolation = { }, },
		[10] = { 69, 25, cooldown = 1.2, levelRequirement = 50, manaCost = 35, statInterpolation = { }, },
		[11] = { 72, 27, cooldown = 1.2, levelRequirement = 52, manaCost = 35, statInterpolation = { }, },
		[12] = { 75, 29, cooldown = 1.2, levelRequirement = 54, manaCost = 35, statInterpolation = { }, },
		[13] = { 78, 31, cooldown = 1.2, levelRequirement = 56, manaCost = 35, statInterpolation = { }, },
		[14] = { 81, 33, cooldown = 1.2, levelRequirement = 58, manaCost = 35, statInterpolation = { }, },
		[15] = { 84, 35, cooldown = 1.2, levelRequirement = 60, manaCost = 35, statInterpolation = { }, },
		[16] = { 87, 36, cooldown = 1.2, levelRequirement = 62, manaCost = 35, statInterpolation = { }, },
		[17] = { 90, 37, cooldown = 1.2, levelRequirement = 64, manaCost = 35, statInterpolation = { }, },
		[18] = { 93, 38, cooldown = 1.2, levelRequirement = 66, manaCost = 35, statInterpolation = { }, },
		[19] = { 96, 39, cooldown = 1.2, levelRequirement = 68, manaCost = 35, statInterpolation = { }, },
		[20] = { 99, 40, cooldown = 1.2, levelRequirement = 70, manaCost = 35, statInterpolation = { }, },
		[21] = { 102, 41, cooldown = 1.2, levelRequirement = 72, manaCost = 35, statInterpolation = { }, },
		[22] = { 105, 42, cooldown = 1.2, levelRequirement = 74, manaCost = 35, statInterpolation = { }, },
		[23] = { 108, 43, cooldown = 1.2, levelRequirement = 76, manaCost = 35, statInterpolation = { }, },
		[24] = { 111, 44, cooldown = 1.2, levelRequirement = 78, manaCost = 35, statInterpolation = { }, },
		[25] = { 114, 45, cooldown = 1.2, levelRequirement = 80, manaCost = 35, statInterpolation = { }, },
		[26] = { 117, 46, cooldown = 1.2, levelRequirement = 82, manaCost = 35, statInterpolation = { }, },
		[27] = { 120, 47, cooldown = 1.2, levelRequirement = 84, manaCost = 35, statInterpolation = { }, },
		[28] = { 123, 48, cooldown = 1.2, levelRequirement = 86, manaCost = 35, statInterpolation = { }, },
		[29] = { 126, 49, cooldown = 1.2, levelRequirement = 88, manaCost = 35, statInterpolation = { }, },
		[30] = { 129, 50, cooldown = 1.2, levelRequirement = 90, manaCost = 35, statInterpolation = { }, },
	},
}
skills["WarlordsMark"] = {
	name = "Warlord's Mark",
	color = 1,
	description = "Curses all targets in an area, making them more vulnerable to stuns. Hitting the cursed targets will leech life and mana, and killing them will result in a chance to gain an endurance charge.",
	skillTypes = { [2] = true, [11] = true, [12] = true, [17] = true, [18] = true, [19] = true, [26] = true, [32] = true, [36] = true, },
	castTime = 0.5,
	statMap = {
		["life_leech_on_any_damage_when_hit_permyriad"] = {
			mod("SelfDamageLifeLeech", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["mana_leech_on_any_damage_when_hit_permyriad"] = {
			mod("SelfDamageManaLeech", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["base_stun_recovery_+%"] = {
			mod("StunRecovery", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
	},
	qualityStats = {
		{ "chance_to_grant_endurance_charge_on_death_%", 0.5 },
	},
	stats = {
		"base_skill_effect_duration",
		"base_skill_area_of_effect_+%",
		"base_stun_recovery_+%",
		"chance_to_be_stunned_%",
		"life_leech_on_any_damage_when_hit_permyriad",
		"mana_leech_on_any_damage_when_hit_permyriad",
		"chance_to_grant_endurance_charge_on_death_%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 6000, 0, -21, 10, 200, 200, 21, manaCost = 24, levelRequirement = 24, statInterpolation = { }, },
		[2] = { 6200, 4, -21, 10, 200, 200, 21, manaCost = 26, levelRequirement = 27, statInterpolation = { }, },
		[3] = { 6400, 8, -22, 10, 200, 200, 22, manaCost = 27, levelRequirement = 30, statInterpolation = { }, },
		[4] = { 6600, 12, -22, 10, 200, 200, 22, manaCost = 29, levelRequirement = 33, statInterpolation = { }, },
		[5] = { 6800, 16, -23, 10, 200, 200, 23, manaCost = 30, levelRequirement = 36, statInterpolation = { }, },
		[6] = { 7000, 20, -23, 10, 200, 200, 23, manaCost = 32, levelRequirement = 39, statInterpolation = { }, },
		[7] = { 7200, 24, -24, 10, 200, 200, 24, manaCost = 34, levelRequirement = 42, statInterpolation = { }, },
		[8] = { 7400, 28, -24, 10, 200, 200, 24, manaCost = 35, levelRequirement = 45, statInterpolation = { }, },
		[9] = { 7600, 32, -25, 10, 200, 200, 25, manaCost = 37, levelRequirement = 48, statInterpolation = { }, },
		[10] = { 7800, 36, -25, 10, 200, 200, 25, manaCost = 38, levelRequirement = 50, statInterpolation = { }, },
		[11] = { 8000, 40, -26, 10, 200, 200, 26, manaCost = 39, levelRequirement = 52, statInterpolation = { }, },
		[12] = { 8200, 44, -26, 10, 200, 200, 26, manaCost = 40, levelRequirement = 54, statInterpolation = { }, },
		[13] = { 8400, 48, -27, 10, 200, 200, 27, manaCost = 42, levelRequirement = 56, statInterpolation = { }, },
		[14] = { 8600, 52, -27, 10, 200, 200, 27, manaCost = 43, levelRequirement = 58, statInterpolation = { }, },
		[15] = { 8800, 56, -28, 10, 200, 200, 28, manaCost = 44, levelRequirement = 60, statInterpolation = { }, },
		[16] = { 9000, 60, -28, 10, 200, 200, 28, manaCost = 45, levelRequirement = 62, statInterpolation = { }, },
		[17] = { 9200, 64, -29, 10, 200, 200, 29, manaCost = 46, levelRequirement = 64, statInterpolation = { }, },
		[18] = { 9400, 68, -29, 10, 200, 200, 29, manaCost = 47, levelRequirement = 66, statInterpolation = { }, },
		[19] = { 9600, 72, -30, 10, 200, 200, 30, manaCost = 48, levelRequirement = 68, statInterpolation = { }, },
		[20] = { 9800, 76, -30, 10, 200, 200, 30, manaCost = 50, levelRequirement = 70, statInterpolation = { }, },
		[21] = { 10000, 80, -31, 10, 200, 200, 31, manaCost = 51, levelRequirement = 72, statInterpolation = { }, },
		[22] = { 10200, 84, -31, 10, 200, 200, 31, manaCost = 52, levelRequirement = 74, statInterpolation = { }, },
		[23] = { 10400, 88, -32, 10, 200, 200, 32, manaCost = 53, levelRequirement = 76, statInterpolation = { }, },
		[24] = { 10600, 92, -32, 10, 200, 200, 32, manaCost = 54, levelRequirement = 78, statInterpolation = { }, },
		[25] = { 10800, 96, -33, 10, 200, 200, 33, manaCost = 56, levelRequirement = 80, statInterpolation = { }, },
		[26] = { 11000, 100, -33, 10, 200, 200, 33, manaCost = 57, levelRequirement = 82, statInterpolation = { }, },
		[27] = { 11200, 104, -34, 10, 200, 200, 34, manaCost = 58, levelRequirement = 84, statInterpolation = { }, },
		[28] = { 11400, 108, -34, 10, 200, 200, 34, manaCost = 59, levelRequirement = 86, statInterpolation = { }, },
		[29] = { 11600, 112, -35, 10, 200, 200, 35, manaCost = 60, levelRequirement = 88, statInterpolation = { }, },
		[30] = { 11800, 116, -35, 10, 200, 200, 35, manaCost = 61, levelRequirement = 90, statInterpolation = { }, },
	},
}